/*This displays Budget Numbers*/
SELECT 'Budget' AS DataSource,
       DS.BUDGETID AS Value,
       DS.YEAR1 AS FiscalYear,
       DS.PERIODID AS FiscalPeriod,
       RTRIM(AN.ACTNUMST) AS AccountNumber,
       RTRIM(AM.ACTDESCR) AS AccountDescription,
       DS.BUDGETAMT AS BudgetAmount,
       0 AS ActualAmount
FROM dbo.GL00100 AS AM
INNER JOIN dbo.GL00105 AS AN ON AM.ACTINDX = AN.ACTINDX
INNER JOIN dbo.GL00201 AS DS ON AM.ACTINDX = DS.ACTINDX

UNION

/*This displays Open Actual Numbers*/
SELECT 'Open' AS DataSource,
       'Actual' AS Value,
       DS.YEAR1 AS FiscalYear,
       DS.PERIODID AS FiscalPeriod,
       RTRIM(AN.ACTNUMST) AS AccountNumber,
       RTRIM(AM.ACTDESCR) AS AccountDescription,
       0 AS BudgetAmount,
       DS.PERDBLNC AS ActualAmount
FROM dbo.GL00100 AS AM
INNER JOIN dbo.GL00105 AS AN ON AM.ACTINDX = AN.ACTINDX
INNER JOIN dbo.GL10110 AS DS ON AM.ACTINDX = DS.ACTINDX

UNION

/*This displays History Actual Numbers*/
SELECT 'History' AS DataSource,
       'Actual' AS Value,
       DS.YEAR1 AS FiscalYear,
       DS.PERIODID AS FiscalPeriod,
       RTRIM(AN.ACTNUMST) AS AccountNumber,
       RTRIM(AM.ACTDESCR) AS AccountDescription,
       0 AS BudgetAmount,
       DS.PERDBLNC AS ActualAmount
FROM dbo.GL00100 AS AM
INNER JOIN dbo.GL00105 AS AN ON AM.ACTINDX = AN.ACTINDX
INNER JOIN dbo.GL10111 AS DS ON AM.ACTINDX = DS.ACTINDX