
/* Powered by General SQL Parser (www.sqlparser.com) */

/************************************************************************************************/ 
/* */ 
/* Tables included: */ 
/* UPR00100 - Employee Master */ 
/* UPR00102 - Employee Address master */ 
/* UPR00300 - Payroll Tax Information Master */ 
/* UPR00400 - Pay Code Master */ 
/* UPR00500 - Employee Deductions */ 
/* UPR00501    - Based On Pay Codes (deductions) */ 
/* UPR00600 - Employee Benefits */ 
/* UPR00601    - Based on Pay Codes (benefits) */ 
/* UPR00700    - Payroll State Tax Master */ 
/* UPR00900 - Employee Summary */ 
/* BE010130 - Benefits and Deductions */ 
/*   DD00100 - Direct Deposit Setup */ 
/* DD00200 - Direct Deposit Account Setup */ 
/* */ 
/* */ 
/* */ 
/************************************************************************************************/ 
--Run this to create the table. 
if exists (select 1 
           from   sysobjects 
           where  name = 'trackPayrollChanges' 
                  and type = 'U') 
  drop table [trackPayrollChanges] 

go 

create table [trackPayrollChanges] ( 
  USERID          char(25), 
  TableName       char(20), 
  ColumnName      char(30), 
  dateTimeChanged datetime, 
  oldValue        char(50), 
  newValue        char(50), 
  employeeID      char(15), 
  Comments        char(200)) 

/*UPR00100*/ 
if exists (select 1 
           from   sysobjects 
           where  name = 'trackEmployeeMasterChanges' 
                  and type = 'tr') 
  drop trigger [trackEmployeeMasterChanges] 

go 

create trigger [trackEmployeeMasterChanges] 
on UPR00100 
for update 
as 
  if update(EMPLCLAS) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'EMPLCLAS', 
             getdate(), 
             cast(a.EMPLCLAS as char(50)), 
             cast(b.EMPLCLAS as char(50)), 
             a.EMPLOYID, 
             'Employee Class changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(INACTIVE) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'INACTIVE', 
             getdate(), 
             cast(a.INACTIVE as char(50)), 
             cast(b.INACTIVE as char(50)), 
             a.EMPLOYID, 
             'Inactive changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(LASTNAME) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'LASTNAME', 
             getdate(), 
             cast(a.LASTNAME as char(50)), 
             cast(b.LASTNAME as char(50)), 
             a.EMPLOYID, 
             'Last Name changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(FRSTNAME) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'FRSTNAME', 
             getdate(), 
             cast(a.FRSTNAME as char(50)), 
             cast(b.FRSTNAME as char(50)), 
             a.EMPLOYID, 
             'First Name changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(MIDLNAME) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'MIDLNAME', 
             getdate(), 
             cast(a.MIDLNAME as char(50)), 
             cast(b.MIDLNAME as char(50)), 
             a.EMPLOYID, 
             'Middle Name changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(ADRSCODE) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'ADRSCODE', 
             getdate(), 
             cast(a.ADRSCODE as char(50)), 
             cast(b.ADRSCODE as char(50)), 
             a.EMPLOYID, 
             'Address Code changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(SOCSCNUM) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'SOCSCNUM', 
             getdate(), 
             cast(a.SOCSCNUM as char(50)), 
             cast(b.SOCSCNUM as char(50)), 
             a.EMPLOYID, 
             'Social Security Number changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(BRTHDATE) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'BRTHDATE', 
             getdate(), 
             cast(a.BRTHDATE as char(50)), 
             cast(b.BRTHDATE as char(50)), 
             a.EMPLOYID, 
             'Birth Date changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(GENDER) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'GENDER', 
             getdate(), 
             cast(a.GENDER as char(50)), 
             cast(b.GENDER as char(50)), 
             a.EMPLOYID, 
             'Gender changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(ETHNORGN) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'ETHNORGN', 
             getdate(), 
             cast(a.ETHNORGN as char(50)), 
             cast(b.ETHNORGN as char(50)), 
             a.EMPLOYID, 
             'Ethnic Origin changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(Calc_Min_Wage_Bal) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'Calc_Min_Wage_Bal', 
             getdate(), 
             cast(a.Calc_Min_Wage_Bal as char(50)), 
             cast(b.Calc_Min_Wage_Bal as char(50)), 
             a.EMPLOYID, 
             'Calculate Minimum Wage Balance changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
   
  if update(DIVISIONCODE_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'DIVISIONCODE_I', 
             getdate(), 
             cast(a.DIVISIONCODE_I as char(50)), 
             cast(b.DIVISIONCODE_I as char(50)), 
             a.EMPLOYID, 
             'Division Code changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
   
  if update(DEPRTMNT) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'DEPRTMNT', 
             getdate(), 
             cast(a.DEPRTMNT as char(50)), 
             cast(b.DEPRTMNT as char(50)), 
             a.EMPLOYID, 
             'Department changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(JOBTITLE) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'JOBTITLE', 
             getdate(), 
             cast(a.JOBTITLE as char(50)), 
             cast(b.JOBTITLE as char(50)), 
             a.EMPLOYID, 
             'Job Title changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(SUPERVISORCODE_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'SUPERVISORCODE_I', 
             getdate(), 
             cast(a.SUPERVISORCODE_I as char(50)), 
             cast(b.SUPERVISORCODE_I as char(50)), 
             a.EMPLOYID, 
             'Supervisor Code changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
   
  if update(LOCATNID) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'LOCATNID', 
             getdate(), 
             cast(a.LOCATNID as char(50)), 
             cast(b.LOCATNID as char(50)), 
             a.EMPLOYID, 
             'Location ID changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(WCACFPAY) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'WCACFPAY', 
             getdate(), 
             cast(a.WCACFPAY as char(50)), 
             cast(b.WCACFPAY as char(50)), 
             a.EMPLOYID, 
             'Which Cash Account for Pay changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(ACTINDX) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'ACTINDX', 
             getdate(), 
             cast(a.ACTINDX as char(50)), 
             cast(b.ACTINDX as char(50)), 
             a.EMPLOYID, 
             'Account index changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(WKHRPRYR) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'WKHRPRYR', 
             getdate(), 
             cast(a.WKHRPRYR as char(50)), 
             cast(b.WKHRPRYR as char(50)), 
             a.EMPLOYID, 
             'Work Hours Per Year changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(STRTDATE) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'STRTDATE', 
             getdate(), 
             cast(a.STRTDATE as char(50)), 
             cast(b.STRTDATE as char(50)), 
             a.EMPLOYID, 
             'Start Date changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(DEMPINAC) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'DEMPINAC', 
             getdate(), 
             cast(a.DEMPINAC as char(50)), 
             cast(b.DEMPINAC as char(50)), 
             a.EMPLOYID, 
             'Date Employee Inactivated changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(RSNEMPIN) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'RSNEMPIN', 
             getdate(), 
             cast(a.RSNEMPIN as char(50)), 
             cast(b.RSNEMPIN as char(50)), 
             a.EMPLOYID, 
             'Reason Employee Inactivated changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(MINETPAY) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'MINETPAY', 
             getdate(), 
             cast(a.MINETPAY as char(50)), 
             cast(b.MINETPAY as char(50)), 
             a.EMPLOYID, 
             'Minimum Net Pay changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(SUTASTAT) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'SUTASTAT', 
             getdate(), 
             cast(a.SUTASTAT as char(50)), 
             cast(b.SUTASTAT as char(50)), 
             a.EMPLOYID, 
             'SUTA State changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(WRKRCOMP) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'WRKRCOMP', 
             getdate(), 
             cast(a.WRKRCOMP as char(50)), 
             cast(b.WRKRCOMP as char(50)), 
             a.EMPLOYID, 
             'Workers Comp changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(ATACRVAC) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'ATACRVAC', 
             getdate(), 
             cast(a.ATACRVAC as char(50)), 
             cast(b.ATACRVAC as char(50)), 
             a.EMPLOYID, 
             'Auto Accrue Vacation changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(VACCRAMT) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'VACCRAMT', 
             getdate(), 
             cast(a.VACCRAMT as char(50)), 
             cast(b.VACCRAMT as char(50)), 
             a.EMPLOYID, 
             'Vacation Accrual Amount changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(VACCRMTH) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'VACCRMTH', 
             getdate(), 
             cast(a.VACCRMTH as char(50)), 
             cast(b.VACCRMTH as char(50)), 
             a.EMPLOYID, 
             'Vacation Accrual Method changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(VACAPRYR) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'VACAPRYR', 
             getdate(), 
             cast(a.VACAPRYR as char(50)), 
             cast(b.VACAPRYR as char(50)), 
             a.EMPLOYID, 
             'Vacation Hours Per Year changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(VACAVLBL) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'VACAVLBL', 
             getdate(), 
             cast(a.VACAVLBL as char(50)), 
             cast(b.VACAVLBL as char(50)), 
             a.EMPLOYID, 
             'Vacation available changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(WRNVCNFLSBLWZR) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'WRNVCNFLSBLWZR', 
             getdate(), 
             cast(a.WRNVCNFLSBLWZR as char(50)), 
             cast(b.WRNVCNFLSBLWZR as char(50)), 
             a.EMPLOYID, 
             'Warn Vacation Falls Below Zero changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
   
  if update(ATACRSTM) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'ATACRSTM', 
             getdate(), 
             cast(a.ATACRSTM as char(50)), 
             cast(b.ATACRSTM as char(50)), 
             a.EMPLOYID, 
             'Auto accrue sick time changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(STMACMTH) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'STMACMTH', 
             getdate(), 
             cast(a.STMACMTH as char(50)), 
             cast(b.STMACMTH as char(50)), 
             a.EMPLOYID, 
             'Sick time accrual method changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(SKTMACAM) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'SKTMACAM', 
             getdate(), 
             cast(a.SKTMACAM as char(50)), 
             cast(b.SKTMACAM as char(50)), 
             a.EMPLOYID, 
             'Sick time accrual amount changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(SIKTIMAV) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'SIKTIMAV', 
             getdate(), 
             cast(a.SIKTIMAV as char(50)), 
             cast(b.SIKTIMAV as char(50)), 
             a.EMPLOYID, 
             'Sick time available changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(SKTMHPYR) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'SKTMHPYR', 
             getdate(), 
             cast(a.SKTMHPYR as char(50)), 
             cast(b.SKTMHPYR as char(50)), 
             a.EMPLOYID, 
             'Sick time hours per year changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(WRNSTFLSBLWZR) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'WRNSTFLSBLWZR', 
             getdate(), 
             cast(a.WRNSTFLSBLWZR as char(50)), 
             cast(b.WRNSTFLSBLWZR as char(50)), 
             a.EMPLOYID, 
             'Warn sick time falls below zero changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
   
  if update(USERDEF1) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'USERDEF1', 
             getdate(), 
             cast(a.USERDEF1 as char(50)), 
             cast(b.USERDEF1 as char(50)), 
             a.EMPLOYID, 
             'User Defined 1 changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(USERDEF2) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'USERDEF2', 
             getdate(), 
             cast(a.USERDEF2 as char(50)), 
             cast(b.USERDEF2 as char(50)), 
             a.EMPLOYID, 
             'User Defined 2 changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(EMPLOYMENTTYPE) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'EMPLOYMENTTYPE', 
             getdate(), 
             cast(a.EMPLOYMENTTYPE as char(50)), 
             cast(b.EMPLOYMENTTYPE as char(50)), 
             a.EMPLOYID, 
             'Employment type changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
   
  if update(MARITALSTATUS) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'MARITALSTATUS', 
             getdate(), 
             cast(a.MARITALSTATUS as char(50)), 
             cast(b.MARITALSTATUS as char(50)), 
             a.EMPLOYID, 
             'Marital Status changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
   
  if update(BENADJDATE) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'BENADJDATE', 
             getdate(), 
             cast(a.BENADJDATE as char(50)), 
             cast(b.BENADJDATE as char(50)), 
             a.EMPLOYID, 
             'Benefits Adjustment Date changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(LASTDAYWORKED_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'LASTDAYWORKED_I', 
             getdate(), 
             cast(a.LASTDAYWORKED_I as char(50)), 
             cast(b.LASTDAYWORKED_I as char(50)), 
             a.EMPLOYID, 
             'Last Day worked changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
   
  if update(BIRTHDAY) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'BIRTHDAY', 
             getdate(), 
             cast(a.BIRTHDAY as char(50)), 
             cast(b.BIRTHDAY as char(50)), 
             a.EMPLOYID, 
             'Birth Day changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(BIRTHMONTH) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'BIRTHMONTH', 
             getdate(), 
             cast(a.BIRTHMONTH as char(50)), 
             cast(b.BIRTHMONTH as char(50)), 
             a.EMPLOYID, 
             'Birth Month changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(SPOUSE) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'SPOUSE', 
             getdate(), 
             cast(a.SPOUSE as char(50)), 
             cast(b.SPOUSE as char(50)), 
             a.EMPLOYID, 
             'Spouse changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(SPOUSESSN) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'SPOUSESSN', 
             getdate(), 
             cast(a.SPOUSESSN as char(50)), 
             cast(b.SPOUSESSN as char(50)), 
             a.EMPLOYID, 
             'Spouse Social Security Number changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(NICKNAME) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'NICKNAME', 
             getdate(), 
             cast(a.NICKNAME as char(50)), 
             cast(b.NICKNAME as char(50)), 
             a.EMPLOYID, 
             'Nickname changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(ALTERNATENAME) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'ALTERNATENAME', 
             getdate(), 
             cast(a.ALTERNATENAME as char(50)), 
             cast(b.ALTERNATENAME as char(50)), 
             a.EMPLOYID, 
             'Alternate name changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
   
  if update(HRSTATUS) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'HRSTATUS', 
             getdate(), 
             cast(a.HRSTATUS as char(50)), 
             cast(b.HRSTATUS as char(50)), 
             a.EMPLOYID, 
             'HR Status changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(DATEOFLASTREVIEW_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'DATEOFLASTREVIEW_I', 
             getdate(), 
             cast(a.DATEOFLASTREVIEW_I as char(50)), 
             cast(b.DATEOFLASTREVIEW_I as char(50)), 
             a.EMPLOYID, 
             'Date of Last Review changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
   
  if update(DATEOFNEXTREVIEW_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'DATEOFNEXTREVIEW_I', 
             getdate(), 
             cast(a.DATEOFNEXTREVIEW_I as char(50)), 
             cast(b.DATEOFNEXTREVIEW_I as char(50)), 
             a.EMPLOYID, 
             'Date of Next Review changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
   
  if update(BENEFITEXPIRE_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'BENEFITEXPIRE_I', 
             getdate(), 
             cast(a.BENEFITEXPIRE_I as char(50)), 
             cast(b.BENEFITEXPIRE_I as char(50)), 
             a.EMPLOYID, 
             'Benefit Expire changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
   
  if update(HANDICAPPED) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'HANDICAPPED', 
             getdate(), 
             cast(a.HANDICAPPED as char(50)), 
             cast(b.HANDICAPPED as char(50)), 
             a.EMPLOYID, 
             'Handicapped changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
   
  if update(VETERAN) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'VETERAN', 
             getdate(), 
             cast(a.VETERAN as char(50)), 
             cast(b.VETERAN as char(50)), 
             a.EMPLOYID, 
             'Veteran changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(VIETNAMVETERAN) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'VIETNAMVETERAN', 
             getdate(), 
             cast(a.VIETNAMVETERAN as char(50)), 
             cast(b.VIETNAMVETERAN as char(50)), 
             a.EMPLOYID, 
             'Vietnam Veteran changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
   
  if update(DISABLEDVETERAN) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'DISABLEDVETERAN', 
             getdate(), 
             cast(a.DISABLEDVETERAN as char(50)), 
             cast(b.DISABLEDVETERAN as char(50)), 
             a.EMPLOYID, 
             'Disabled Veteran changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
   
  if update(UNIONEMPLOYEE) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'UNIONEMPLOYEE', 
             getdate(), 
             cast(a.UNIONEMPLOYEE as char(50)), 
             cast(b.UNIONEMPLOYEE as char(50)), 
             a.EMPLOYID, 
             'Union employee changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
   
  if update(SMOKER_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'SMOKER_I', 
             getdate(), 
             cast(a.SMOKER_I as char(50)), 
             cast(b.SMOKER_I as char(50)), 
             a.EMPLOYID, 
             'Smoker changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(CITIZEN) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'CITIZEN', 
             getdate(), 
             cast(a.CITIZEN as char(50)), 
             cast(b.CITIZEN as char(50)), 
             a.EMPLOYID, 
             'Citizen changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(VERIFIED) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'VERIFIED', 
             getdate(), 
             cast(a.VERIFIED as char(50)), 
             cast(b.VERIFIED as char(50)), 
             a.EMPLOYID, 
             'Verified changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(I9RENEW) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'I9RENEW', 
             getdate(), 
             cast(a.I9RENEW as char(50)), 
             cast(b.I9RENEW as char(50)), 
             a.EMPLOYID, 
             'I9 renew changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(Primary_Pay_Record) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'Primary_Pay_Record', 
             getdate(), 
             cast(a.Primary_Pay_Record as char(50)), 
             cast(b.Primary_Pay_Record as char(50)), 
             a.EMPLOYID, 
             'Primary Pay Record changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
   
  if update(CHANGEBY_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'CHANGEBY_I', 
             getdate(), 
             cast(a.CHANGEBY_I as char(50)), 
             cast(b.CHANGEBY_I as char(50)), 
             a.EMPLOYID, 
             'Change By changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(CHANGEDATE_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'CHANGEDATE_I', 
             getdate(), 
             cast(a.CHANGEDATE_I as char(50)), 
             cast(b.CHANGEDATE_I as char(50)), 
             a.EMPLOYID, 
             'Change Date changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(UNIONCD) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'UNIONCD', 
             getdate(), 
             cast(a.UNIONCD as char(50)), 
             cast(b.UNIONCD as char(50)), 
             a.EMPLOYID, 
             'Union Code changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(RATECLSS) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'RATECLSS', 
             getdate(), 
             cast(a.RATECLSS as char(50)), 
             cast(b.RATECLSS as char(50)), 
             a.EMPLOYID, 
             'Rate Class changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(FEDCLSSCD) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'FEDCLSSCD', 
             getdate(), 
             cast(a.FEDCLSSCD as char(50)), 
             cast(b.FEDCLSSCD as char(50)), 
             a.EMPLOYID, 
             'Federal Classification Code changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(OTHERVET) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00100', 
             'OTHERVET', 
             getdate(), 
             cast(a.OTHERVET as char(50)), 
             cast(b.OTHERVET as char(50)), 
             a.EMPLOYID, 
             'Other veterans changed for Employee: ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 

go 

if exists (select 1 
           from   sysobjects 
           where  name = 'trackEmployeeAdditions' 
                  and type = 'tr') 
  drop trigger [trackEmployeeAdditions] 

go 

create trigger [trackEmployeeAdditions] 
on UPR00100 
for insert 
as 
  insert trackPayrollChanges 
  select system_user, 
         'UPR00100', 
         'Inserted Record', 
         getdate(), 
         'Inserted Record', 
         'Inserted Record', 
         EMPLOYID, 
         'Employee ' + rtrim(EMPLOYID) + ' was added' 
  from   inserted 

go 

/*UPR00300*/ 
if exists (select 1 
           from   sysobjects 
           where  name = 'trackEmployeeTaxAdditions' 
                  and type = 'tr') 
  drop trigger [trackEmployeeTaxAdditions] 

go 

create trigger [trackEmployeeTaxAdditions] 
on UPR00300 
for insert 
as 
  insert trackPayrollChanges 
  select system_user, 
         'UPR00300', 
         'Inserted Record', 
         getdate(), 
         'Inserted Record', 
         'Inserted Record', 
         EMPLOYID, 
         'Tax Information for employee ' + rtrim(EMPLOYID) + ' was added' 
  from   inserted 

go 

if exists (select 1 
           from   sysobjects 
           where  name = 'trackHRChangesOnUPR00300' 
                  and type = 'tr') 
  drop trigger [trackHRChangesOnUPR00300] 

go 

create trigger [trackHRChangesOnUPR00300] 
on UPR00300 
for update 
as 
  if update(EXMFRFED) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00300', 
             'EXMFRFED', 
             getdate(), 
             cast(a.EXMFRFED as char(50)), 
             cast(b.EXMFRFED as char(50)), 
             a.EMPLOYID, 
             'Federal Filing Status was changed for ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(FDFLGSTS) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00300', 
             'FDFLGSTS', 
             getdate(), 
             cast(a.FDFLGSTS as char(50)), 
             cast(b.FDFLGSTS as char(50)), 
             a.EMPLOYID, 
             'Federal Filing Status was changed for ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(FEDEXMPT) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00300', 
             'FEDEXMPT', 
             getdate(), 
             cast(a.FEDEXMPT as char(50)), 
             cast(b.FEDEXMPT as char(50)), 
             a.EMPLOYID, 
             'Number of Exemptions was changed for ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(ADFDWHDG) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00300', 
             'ADFDWHDG', 
             getdate(), 
             cast(a.ADFDWHDG as char(50)), 
             cast(b.ADFDWHDG as char(50)), 
             a.EMPLOYID, 
             'Additional Withholding was changed for ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(ESTFEDWH) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00300', 
             'ESTFEDWH', 
             getdate(), 
             cast(a.ESTFEDWH as char(50)), 
             cast(b.ESTFEDWH as char(50)), 
             a.EMPLOYID, 
             'Estimated withholding was changed for ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(STATECD) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00300', 
             'STATECD', 
             getdate(), 
             cast(a.STATECD as char(50)), 
             cast(b.STATECD as char(50)), 
             a.EMPLOYID, 
             'Tax Withholding State was changed for ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(LOCALTAX) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00300', 
             'LOCALTAX', 
             getdate(), 
             cast(a.LOCALTAX as char(50)), 
             cast(b.LOCALTAX as char(50)), 
             a.EMPLOYID, 
             'Local Tax Code was changed for ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(W2BF942E) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00300', 
             'W2BF942E', 
             getdate(), 
             cast(a.W2BF942E as char(50)), 
             cast(b.W2BF942E as char(50)), 
             a.EMPLOYID, 
             'Household Employee Checkbox changed for ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(W2BFDCSD) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00300', 
             'W2BFDCSD', 
             getdate(), 
             cast(a.W2BFDCSD as char(50)), 
             cast(b.W2BFDCSD as char(50)), 
             a.EMPLOYID, 
             'W-2 box for deceased changed for ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(W2BFDCMP) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00300', 
             'W2BFDCMP', 
             getdate(), 
             cast(a.W2BFDCMP as char(50)), 
             cast(b.W2BFDCMP as char(50)), 
             a.EMPLOYID, 
             'W-2 box for Deferred Compensation changed for ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(W2BFLREP) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00300', 
             'W2BFLREP', 
             getdate(), 
             cast(a.W2BFLREP as char(50)), 
             cast(b.W2BFLREP as char(50)), 
             a.EMPLOYID, 
             'W-2 box for legal representation changed for ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(W2BFPPLN) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00300', 
             'W2BFPPLN', 
             getdate(), 
             cast(a.W2BFPPLN as char(50)), 
             cast(b.W2BFPPLN as char(50)), 
             a.EMPLOYID, 
             'W-2 box for pension plan changed for ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(W2BFSTEM) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00300', 
             'W2BFSTEM', 
             getdate(), 
             cast(a.W2BFSTEM as char(50)), 
             cast(b.W2BFSTEM as char(50)), 
             a.EMPLOYID, 
             'Subject to FICA not federal was changed for ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(MCRQGEMP) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00300', 
             'MCRQGEMP', 
             getdate(), 
             cast(a.MCRQGEMP as char(50)), 
             cast(b.MCRQGEMP as char(50)), 
             a.EMPLOYID, 
             'Medicare Qualified Government Employee changed for ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(EICFLGST) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00300', 
             'EICFLGST', 
             getdate(), 
             cast(a.EICFLGST as char(50)), 
             cast(b.EICFLGST as char(50)), 
             a.EMPLOYID, 
             'EIC Filing Status changed for ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
     
  if update(NYTXDiff) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00300', 
             'NYTXDiff', 
             getdate(), 
             cast(a.NYTXDiff as char(50)), 
             cast(b.NYTXDiff as char(50)), 
             a.EMPLOYID, 
             'Withheld NY Tax Difference changed for ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 

go 

/*UPR00400*/ 
if exists (select 1 
           from   sysobjects 
           where  name = 'trackPayRateChanges' 
                  and type = 'tr') 
  drop trigger [trackPayRateChanges] 

go 

create trigger [trackPayRateChanges] 
on UPR00400 
for update 
as 
  if update(PAYRTAMT) 
    begin 
      set nocount on 
       
      insert trackPayrollChanges 
      select system_user, 
             'UPR00400', 
             'PAYRTAMT', 
             getdate(), 
             cast(a.PAYRTAMT as char(50)), 
             cast(b.PAYRTAMT as char(50)), 
             a.EMPLOYID, 
             'Payrate was updated for ' + rtrim(a.EMPLOYID) + ' for paycode ' + rtrim(a.PAYRCORD) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.PAYRCORD = b.PAYRCORD 
    end 
   
  if update(PAYUNIT) 
    begin 
      set nocount on 
       
      insert trackPayrollChanges 
      select system_user, 
             'UPR00400', 
             'PAYUNIT', 
             getdate(), 
             cast(a.PAYUNIT as char(50)), 
             cast(b.PAYUNIT as char(50)), 
             a.EMPLOYID, 
             'Unit of pay was updated for ' + rtrim(a.EMPLOYID) + ' for paycode ' + rtrim(a.PAYRCORD) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.PAYRCORD = b.PAYRCORD 
    end 
   
  if update(PAYPEROD) 
    begin 
      set nocount on 
       
      insert trackPayrollChanges 
      select system_user, 
             'UPR00400', 
             'PAYPEROD', 
             getdate(), 
             cast(a.PAYPEROD as char(50)), 
             cast(b.PAYPEROD as char(50)), 
             a.EMPLOYID, 
             'Pay Period was updated for ' + rtrim(a.EMPLOYID) + ' for paycode ' + rtrim(a.PAYRCORD) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.PAYRCORD = b.PAYRCORD 
    end 
   
  if update(TAXABLE) 
    begin 
      set nocount on 
       
      insert trackPayrollChanges 
      select system_user, 
             'UPR00400', 
             'TAXABLE', 
             getdate(), 
             cast(a.TAXABLE as char(50)), 
             cast(b.TAXABLE as char(50)), 
             a.EMPLOYID, 
             'Pay Period was updated for ' + rtrim(a.EMPLOYID) + ' for paycode ' + rtrim(a.PAYRCORD) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.PAYRCORD = b.PAYRCORD 
    end 
   
  if update(SBJTFDTX) 
    begin 
      set nocount on 
       
      insert trackPayrollChanges 
      select system_user, 
             'UPR00400', 
             'SBJTFDTX', 
             getdate(), 
             cast(a.SBJTFDTX as char(50)), 
             cast(b.SBJTFDTX as char(50)), 
             a.EMPLOYID, 
             'Subject to Federal Tax was updated for ' + rtrim(a.EMPLOYID) + ' for paycode ' + rtrim(a.PAYRCORD) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.PAYRCORD = b.PAYRCORD 
    end 
     
  if update(SBJTSSEC) 
    begin 
      set nocount on 
       
      insert trackPayrollChanges 
      select system_user, 
             'UPR00400', 
             'SBJTSSEC', 
             getdate(), 
             cast(a.SBJTSSEC as char(50)), 
             cast(b.SBJTSSEC as char(50)), 
             a.EMPLOYID, 
             'Subject to FICA Social Security Tax was updated for ' + rtrim(a.EMPLOYID) + ' for paycode ' + rtrim(a.PAYRCORD) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.PAYRCORD = b.PAYRCORD 
    end 
     
  if update(SBJTMCAR) 
    begin 
      set nocount on 
       
      insert trackPayrollChanges 
      select system_user, 
             'UPR00400', 
             'SBJTMCAR', 
             getdate(), 
             cast(a.SBJTMCAR as char(50)), 
             cast(b.SBJTMCAR as char(50)), 
             a.EMPLOYID, 
             'Subject to Medicare Tax was updated for ' + rtrim(a.EMPLOYID) + ' for paycode ' + rtrim(a.PAYRCORD) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.PAYRCORD = b.PAYRCORD 
    end 
     
  if update(SBJTSTTX) 
    begin 
      set nocount on 
       
      insert trackPayrollChanges 
      select system_user, 
             'UPR00400', 
             'SBJTSTTX', 
             getdate(), 
             cast(a.SBJTSTTX as char(50)), 
             cast(b.SBJTSTTX as char(50)), 
             a.EMPLOYID, 
             'Subject to State Tax was updated for ' + rtrim(a.EMPLOYID) + ' for paycode ' + rtrim(a.PAYRCORD) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.PAYRCORD = b.PAYRCORD 
    end 
     
  if update(SBJTFUTA) 
    begin 
      set nocount on 
       
      insert trackPayrollChanges 
      select system_user, 
             'UPR00400', 
             'SBJTFUTA', 
             getdate(), 
             cast(a.SBJTFUTA as char(50)), 
             cast(b.SBJTFUTA as char(50)), 
             a.EMPLOYID, 
             'Subject to FUTA Tax was updated for ' + rtrim(a.EMPLOYID) + ' for paycode ' + rtrim(a.PAYRCORD) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.PAYRCORD = b.PAYRCORD 
    end 
     
  if update(SBJTSUTA) 
    begin 
      set nocount on 
       
      insert trackPayrollChanges 
      select system_user, 
             'UPR00400', 
             'SBJTSUTA', 
             getdate(), 
             cast(a.SBJTSUTA as char(50)), 
             cast(b.SBJTSUTA as char(50)), 
             a.EMPLOYID, 
             'Subject to SUTA Tax was updated for ' + rtrim(a.EMPLOYID) + ' for paycode ' + rtrim(a.PAYRCORD) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.PAYRCORD = b.PAYRCORD 
    end 
     
  if update(SUTASTAT) 
    begin 
      set nocount on 
       
      insert trackPayrollChanges 
      select system_user, 
             'UPR00400', 
             'SUTASTAT', 
             getdate(), 
             cast(a.SUTASTAT as char(50)), 
             cast(b.SUTASTAT as char(50)), 
             a.EMPLOYID, 
             'SUTA State was updated for ' + rtrim(a.EMPLOYID) + ' for paycode ' + rtrim(a.PAYRCORD) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.PAYRCORD = b.PAYRCORD 
    end 
     
  if update(SBJTSTTX) 
    begin 
      set nocount on 
       
      insert trackPayrollChanges 
      select system_user, 
             'UPR00400', 
             'SBJTSTTX', 
             getdate(), 
             cast(a.SBJTSTTX as char(50)), 
             cast(b.SBJTSTTX as char(50)), 
             a.EMPLOYID, 
             'Subject to State Tax was updated for ' + rtrim(a.EMPLOYID) + ' for paycode ' + rtrim(a.PAYRCORD) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.PAYRCORD = b.PAYRCORD 
    end 
     
  if update(SBJTLTAX) 
    begin 
      set nocount on 
       
      insert trackPayrollChanges 
      select system_user, 
             'UPR00400', 
             'SBJTLTAX', 
             getdate(), 
             cast(a.SBJTLTAX as char(50)), 
             cast(b.SBJTLTAX as char(50)), 
             a.EMPLOYID, 
             'Subject to Local Tax was updated for ' + rtrim(a.EMPLOYID) + ' for paycode ' + rtrim(a.PAYRCORD) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.PAYRCORD = b.PAYRCORD 
    end 

go 

if exists (select 1 
           from   sysobjects 
           where  name = 'trackPayRateAdditions' 
                  and type = 'tr') 
  drop trigger [trackPayRateAdditions] 

go 

create trigger [trackPayRateAdditions] 
on UPR00400 
for insert 
as 
  insert trackPayrollChanges 
  select system_user, 
         'UPR00400', 
         'Inserted Record', 
         getdate(), 
         'Inserted Record', 
         'Inserted Record', 
         EMPLOYID, 
         'Record with DEX_ROW_ID ' + rtrim(cast(DEX_ROW_ID as char(6))) + ' was added for employee ' + rtrim(EMPLOYID) + ' for pay code ' + rtrim(PAYRCORD) 
  from   inserted 

go 

/*UPR00500*/ 
if exists (select 1 
           from   sysobjects 
           where  name = 'trackDeductionChanges' 
                  and type = 'tr') 
  drop trigger [trackDeductionChanges] 

go 

create trigger [trackDeductionChanges] 
on UPR00500 
for update 
as 
  if update(INACTIVE) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'INACTIVE', 
             getdate(), 
             cast(a.INACTIVE as char(50)), 
             cast(b.INACTIVE as char(50)), 
             a.EMPLOYID, 
             rtrim(a.EMPLOYID) + ' was inactivated' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DEDBEGDT) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DEDBEGDT', 
             getdate(), 
             cast(a.DEDBEGDT as char(50)), 
             cast(b.DEDBEGDT as char(50)), 
             a.EMPLOYID, 
             'Deduction Start Date was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DEDENDDT) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DEDENDDT', 
             getdate(), 
             cast(a.DEDENDDT as char(50)), 
             cast(b.DEDENDDT as char(50)), 
             a.EMPLOYID, 
             'Deduction End Date was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(VARDEDTN) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'VARDEDTN', 
             getdate(), 
             cast(a.VARDEDTN as char(50)), 
             cast(b.VARDEDTN as char(50)), 
             a.EMPLOYID, 
             'Deduction Transaction Required was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DEDNFREQ) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DEDNFREQ', 
             getdate(), 
             cast(a.DEDNFREQ as char(50)), 
             cast(b.DEDNFREQ as char(50)), 
             a.EMPLOYID, 
             'Deduction Frequency was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(SFRFEDTX) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'SFRFEDTX', 
             getdate(), 
             cast(a.SFRFEDTX as char(50)), 
             cast(b.SFRFEDTX as char(50)), 
             a.EMPLOYID, 
             'Federal tax TSA Sheltered from was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(SHFRFICA) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'SHFRFICA', 
             getdate(), 
             cast(a.SHFRFICA as char(50)), 
             cast(b.SHFRFICA as char(50)), 
             a.EMPLOYID, 
             'FICA TSA Sheltered from was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(SHFRSTTX) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'SHFRSTTX', 
             getdate(), 
             cast(a.SHFRSTTX as char(50)), 
             cast(b.SHFRSTTX as char(50)), 
             a.EMPLOYID, 
             'State Tax TSA Sheltered from was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(SFRLCLTX) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'SFRLCLTX', 
             getdate(), 
             cast(a.SFRLCLTX as char(50)), 
             cast(b.SFRLCLTX as char(50)), 
             a.EMPLOYID, 
             'Local tax TSA Sheltered from was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(BSDORCDS) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'BSDORCDS', 
             getdate(), 
             cast(a.BSDORCDS as char(50)), 
             cast(b.BSDORCDS as char(50)), 
             a.EMPLOYID, 
             'Based on Codes were changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DEDNMTHD) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DEDNMTHD', 
             getdate(), 
             cast(a.DEDNMTHD as char(50)), 
             cast(b.DEDNMTHD as char(50)), 
             a.EMPLOYID, 
             'Deduction Method was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DEDFRMLA) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DEDFRMLA', 
             getdate(), 
             cast(a.DEDFRMLA as char(50)), 
             cast(b.DEDFRMLA as char(50)), 
             a.EMPLOYID, 
             'Deduction Tier was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DEDNPRCT_1) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DEDNPRCT_1', 
             getdate(), 
             cast(a.DEDNPRCT_1 as char(50)), 
             cast(b.DEDNPRCT_1 as char(50)), 
             a.EMPLOYID, 
             'Single Deduction Tier was updated for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DEDNPRCT_2) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DEDNPRCT_2', 
             getdate(), 
             cast(a.DEDNPRCT_2 as char(50)), 
             cast(b.DEDNPRCT_2 as char(50)), 
             a.EMPLOYID, 
             'Multiple Tier Deduction Percentage was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DEDNPRCT_3) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DEDNPRCT_3', 
             getdate(), 
             cast(a.DEDNPRCT_3 as char(50)), 
             cast(b.DEDNPRCT_3 as char(50)), 
             a.EMPLOYID, 
             'Multiple Tier Deduction Percentage was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DEDNPRCT_4) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DEDNPRCT_4', 
             getdate(), 
             cast(a.DEDNPRCT_4 as char(50)), 
             cast(b.DEDNPRCT_4 as char(50)), 
             a.EMPLOYID, 
             'Multiple Tier Deduction Percentage was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DEDNPRCT_5) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DEDNPRCT_5', 
             getdate(), 
             cast(a.DEDNPRCT_5 as char(50)), 
             cast(b.DEDNPRCT_5 as char(50)), 
             a.EMPLOYID, 
             'Multiple Tier Deduction Percentage was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DEDCAMNT_1) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DEDCAMNT_1', 
             getdate(), 
             cast(a.DEDCAMNT_1 as char(50)), 
             cast(b.DEDCAMNT_1 as char(50)), 
             a.EMPLOYID, 
             'Multiple Tier Deduction Percentage was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DEDCAMNT_2) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DEDCAMNT_2', 
             getdate(), 
             cast(a.DEDCAMNT_2 as char(50)), 
             cast(b.DEDCAMNT_2 as char(50)), 
             a.EMPLOYID, 
             'Multiple Tier Deduction Percentage was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DEDCAMNT_3) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DEDCAMNT_3', 
             getdate(), 
             cast(a.DEDCAMNT_3 as char(50)), 
             cast(b.DEDCAMNT_3 as char(50)), 
             a.EMPLOYID, 
             'Multiple Tier Deduction Percentage was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DEDCAMNT_4) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DEDCAMNT_4', 
             getdate(), 
             cast(a.DEDCAMNT_4 as char(50)), 
             cast(b.DEDCAMNT_4 as char(50)), 
             a.EMPLOYID, 
             'Multiple Tier Deduction Percentage was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DEDCAMNT_5) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DEDCAMNT_5', 
             getdate(), 
             cast(a.DEDCAMNT_5 as char(50)), 
             cast(b.DEDCAMNT_5 as char(50)), 
             a.EMPLOYID, 
             'Multiple Tier Deduction Percentage was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DEDTRMAX_1) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DEDTRMAX_1', 
             getdate(), 
             cast(a.DEDTRMAX_1 as char(50)), 
             cast(b.DEDTRMAX_1 as char(50)), 
             a.EMPLOYID, 
             'Multiple Tier Deduction Percentage was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DEDTRMAX_2) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DEDTRMAX_2', 
             getdate(), 
             cast(a.DEDTRMAX_2 as char(50)), 
             cast(b.DEDTRMAX_2 as char(50)), 
             a.EMPLOYID, 
             'Multiple Tier Deduction Percentage was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DEDTRMAX_3) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DEDTRMAX_3', 
             getdate(), 
             cast(a.DEDTRMAX_3 as char(50)), 
             cast(b.DEDTRMAX_3 as char(50)), 
             a.EMPLOYID, 
             'Multiple Tier Deduction Percentage was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DEDTRMAX_4) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DEDTRMAX_4', 
             getdate(), 
             cast(a.DEDTRMAX_4 as char(50)), 
             cast(b.DEDTRMAX_4 as char(50)), 
             a.EMPLOYID, 
             'Multiple Tier Deduction Percentage was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DEDTRMAX_5) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DEDTRMAX_5', 
             getdate(), 
             cast(a.DEDTRMAX_5 as char(50)), 
             cast(b.DEDTRMAX_5 as char(50)), 
             a.EMPLOYID, 
             'Multiple Tier Deduction Percentage was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DETRMXUN_1) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DETRMXUN_1', 
             getdate(), 
             cast(a.DETRMXUN_1 as char(50)), 
             cast(b.DETRMXUN_1 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DETRMXUN_2) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DETRMXUN_2', 
             getdate(), 
             cast(a.DETRMXUN_2 as char(50)), 
             cast(b.DETRMXUN_2 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DETRMXUN_3) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DETRMXUN_3', 
             getdate(), 
             cast(a.DETRMXUN_3 as char(50)), 
             cast(b.DETRMXUN_3 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DETRMXUN_4) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DETRMXUN_4', 
             getdate(), 
             cast(a.DETRMXUN_4 as char(50)), 
             cast(b.DETRMXUN_4 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DETRMXUN_5) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DETRMXUN_5', 
             getdate(), 
             cast(a.DETRMXUN_5 as char(50)), 
             cast(b.DETRMXUN_5 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DEPYPRMX) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DEPYPRMX', 
             getdate(), 
             cast(a.DEPYPRMX as char(50)), 
             cast(b.DEPYPRMX as char(50)), 
             a.EMPLOYID, 
             'Pay Period Maximum Deduction was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DEDYRMAX) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DEDYRMAX', 
             getdate(), 
             cast(a.DEDYRMAX as char(50)), 
             cast(b.DEDYRMAX as char(50)), 
             a.EMPLOYID, 
             'Year Maximum Deduction was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DEDLTMAX) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DEDLTMAX', 
             getdate(), 
             cast(a.DEDLTMAX as char(50)), 
             cast(b.DEDLTMAX as char(50)), 
             a.EMPLOYID, 
             'Lifetime Maximum Deduction was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(W2BXNMBR) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'W2BXNMBR', 
             getdate(), 
             cast(a.W2BXNMBR as char(50)), 
             cast(b.W2BXNMBR as char(50)), 
             a.EMPLOYID, 
             'W-2 Box Number was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(W2BXLABL) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'W2BXLABL', 
             getdate(), 
             cast(a.W2BXLABL as char(50)), 
             cast(b.W2BXLABL as char(50)), 
             a.EMPLOYID, 
             'W-2 Tax Label was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(LTDDEDTN) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'LTDDEDTN', 
             getdate(), 
             cast(a.LTDDEDTN as char(50)), 
             cast(b.LTDDEDTN as char(50)), 
             a.EMPLOYID, 
             'Life To Date Deduction was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 
     
  if update(DATAENTDFLT) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00500', 
             'DATAENTDFLT', 
             getdate(), 
             cast(a.DATAENTDFLT as char(50)), 
             cast(b.DATAENTDFLT as char(50)), 
             a.EMPLOYID, 
             'Data Entry Default was changed for Deduction code' + rtrim(a.DEDUCTON) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.DEDUCTON = b.DEDUCTON 
    end 

go 

if exists (select 1 
           from   sysobjects 
           where  name = 'trackDeductionAdditions' 
                  and type = 'tr') 
  drop trigger [trackDeductionAdditions] 

go 

create trigger [trackDeductionAdditions] 
on UPR00500 
for insert 
as 
  insert trackPayrollChanges 
  select system_user, 
         'UPR00500', 
         'Inserted Record', 
         getdate(), 
         'Inserted Record', 
         'Inserted Record', 
         EMPLOYID, 
         'Record with DEX_ROW_ID ' + rtrim(cast(DEX_ROW_ID as char(6))) + ' was added for employee ' + rtrim(EMPLOYID) + ' for deduction ' + rtrim(DEDUCTON) 
  from   inserted 

go 

/*UPR00501*/ 
go 

if exists (select 1 
           from   sysobjects 
           where  name = 'trackDedBasedOnAdditions' 
                  and type = 'tr') 
  drop trigger [trackDedBasedOnAdditions] 

go 

create trigger [trackDedBasedOnAdditions] 
on UPR00501 
for insert 
as 
  insert trackPayrollChanges 
  select system_user, 
         'UPR00501', 
         'Inserted Record', 
         getdate(), 
         'Inserted Record', 
         'Inserted Record', 
         EMPLOYID, 
         'Record with DEX_ROW_ID ' + rtrim(cast(DEX_ROW_ID as char(6))) + ' was added for employee ' + rtrim(EMPLOYID) + ' for deduction ' + rtrim(DEDUCTON) 
  from   inserted 

go 

/*UPR00600*/ 
if exists (select 1 
           from   sysobjects 
           where  name = 'findBenefitChanges' 
                  and type = 'tr') 
  drop trigger [findBenefitChanges] 

go 

create trigger [findBenefitChanges] 
on UPR00600 
for update 
as 
  if update(INACTIVE) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'INACTIVE', 
             getdate(), 
             cast(a.INACTIVE as char(50)), 
             cast(b.INACTIVE as char(50)), 
             a.EMPLOYID, 
             'Benefits were inactivated for ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFBEGDT) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNFBEGDT', 
             getdate(), 
             cast(a.BNFBEGDT as char(50)), 
             cast(b.BNFBEGDT as char(50)), 
             a.EMPLOYID, 
             'Benefit Start date was inactivated for Benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFENDDT) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNFENDDT', 
             getdate(), 
             cast(a.BNFENDDT as char(50)), 
             cast(b.BNFENDDT as char(50)), 
             a.EMPLOYID, 
             'Benefit End date was inactivated for Benefit' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(VARBENFT) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'VARBENFT', 
             getdate(), 
             cast(a.VARBENFT as char(50)), 
             cast(b.VARBENFT as char(50)), 
             a.EMPLOYID, 
             'Benefit Transaction Required was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFTFREQ) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNFTFREQ', 
             getdate(), 
             cast(a.BNFTFREQ as char(50)), 
             cast(b.BNFTFREQ as char(50)), 
             a.EMPLOYID, 
             'Benefit Frequency was changed for Benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(TAXABLE) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'TAXABLE', 
             getdate(), 
             cast(a.TAXABLE as char(50)), 
             cast(b.TAXABLE as char(50)), 
             a.EMPLOYID, 
             'Benefit Subject to tax was changed for ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(SBJTFDTX) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'SBJTFDTX', 
             getdate(), 
             cast(a.SBJTFDTX as char(50)), 
             cast(b.SBJTFDTX as char(50)), 
             a.EMPLOYID, 
             'Benefit Subject to Federal tax was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(SBJTSSEC) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'SBJTSSEC', 
             getdate(), 
             cast(a.SBJTSSEC as char(50)), 
             cast(b.SBJTSSEC as char(50)), 
             a.EMPLOYID, 
             'Benefit subject to FICA Social Security was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(SBJTMCAR) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'SBJTMCAR', 
             getdate(), 
             cast(a.SBJTMCAR as char(50)), 
             cast(b.SBJTMCAR as char(50)), 
             a.EMPLOYID, 
             'Benefit subject for Medicare was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(SBJTSTTX) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'SBJTSTTX', 
             getdate(), 
             cast(a.SBJTSTTX as char(50)), 
             cast(b.SBJTSTTX as char(50)), 
             a.EMPLOYID, 
             'Benefit Subject to State Tax was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(SBJTLTAX) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'SBJTLTAX', 
             getdate(), 
             cast(a.SBJTLTAX as char(50)), 
             cast(b.SBJTLTAX as char(50)), 
             a.EMPLOYID, 
             'Benefit Subject to Local Tax was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(SBJTFUTA) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'SBJTFUTA', 
             getdate(), 
             cast(a.SBJTFUTA as char(50)), 
             cast(b.SBJTFUTA as char(50)), 
             a.EMPLOYID, 
             'Benefit subject to FUTA was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(SBJTSUTA) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'SBJTSUTA', 
             getdate(), 
             cast(a.SBJTSUTA as char(50)), 
             cast(b.SBJTSUTA as char(50)), 
             a.EMPLOYID, 
             'Benefit subject to SUTA was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(FFEDTXRT) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'FFEDTXRT', 
             getdate(), 
             cast(a.FFEDTXRT as char(50)), 
             cast(b.FFEDTXRT as char(50)), 
             a.EMPLOYID, 
             'Benefit Flat Federal Tax Rate was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(FLSTTXRT) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'FLSTTXRT', 
             getdate(), 
             cast(a.FLSTTXRT as char(50)), 
             cast(b.FLSTTXRT as char(50)), 
             a.EMPLOYID, 
             'Flat State Tax Rate was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BORCDTYP) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BORCDTYP', 
             getdate(), 
             cast(a.BORCDTYP as char(50)), 
             cast(b.BORCDTYP as char(50)), 
             a.EMPLOYID, 
             'Based on was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BSDORCDS) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BSDORCDS', 
             getdate(), 
             cast(a.BSDORCDS as char(50)), 
             cast(b.BSDORCDS as char(50)), 
             a.EMPLOYID, 
             'Based on was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFTMTHD) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNFTMTHD', 
             getdate(), 
             cast(a.BNFTMTHD as char(50)), 
             cast(b.BNFTMTHD as char(50)), 
             a.EMPLOYID, 
             'Benefit Method was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFFRMLA) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNFFRMLA', 
             getdate(), 
             cast(a.BNFFRMLA as char(50)), 
             cast(b.BNFFRMLA as char(50)), 
             a.EMPLOYID, 
             'Benefit Tier was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFPRCNT_1) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNFPRCNT_1', 
             getdate(), 
             cast(a.BNFPRCNT_1 as char(50)), 
             cast(b.BNFPRCNT_1 as char(50)), 
             a.EMPLOYID, 
             'Benefit Tier Percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFPRCNT_2) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNFPRCNT_2', 
             getdate(), 
             cast(a.BNFPRCNT_2 as char(50)), 
             cast(b.BNFPRCNT_2 as char(50)), 
             a.EMPLOYID, 
             'Benefit Tier Percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFPRCNT_3) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNFPRCNT_3', 
             getdate(), 
             cast(a.BNFPRCNT_3 as char(50)), 
             cast(b.BNFPRCNT_3 as char(50)), 
             a.EMPLOYID, 
             'Benefit Tier Percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFPRCNT_4) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNFPRCNT_4', 
             getdate(), 
             cast(a.BNFPRCNT_4 as char(50)), 
             cast(b.BNFPRCNT_4 as char(50)), 
             a.EMPLOYID, 
             'Benefit Tier Percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFPRCNT_5) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNFPRCNT_5', 
             getdate(), 
             cast(a.BNFPRCNT_5 as char(50)), 
             cast(b.BNFPRCNT_5 as char(50)), 
             a.EMPLOYID, 
             'Benefit Tier Percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFITAMT_1) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNFITAMT_1', 
             getdate(), 
             cast(a.BNFITAMT_1 as char(50)), 
             cast(b.BNFITAMT_1 as char(50)), 
             a.EMPLOYID, 
             'Benefit Tier Percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFITAMT_2) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNFITAMT_2', 
             getdate(), 
             cast(a.BNFITAMT_2 as char(50)), 
             cast(b.BNFITAMT_2 as char(50)), 
             a.EMPLOYID, 
             'Benefit Tier Percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFITAMT_3) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNFITAMT_3', 
             getdate(), 
             cast(a.BNFITAMT_3 as char(50)), 
             cast(b.BNFITAMT_3 as char(50)), 
             a.EMPLOYID, 
             'Benefit Tier Percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFITAMT_4) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNFITAMT_4', 
             getdate(), 
             cast(a.BNFITAMT_4 as char(50)), 
             cast(b.BNFITAMT_4 as char(50)), 
             a.EMPLOYID, 
             'Benefit Tier Percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFITAMT_5) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNFITAMT_5', 
             getdate(), 
             cast(a.BNFITAMT_5 as char(50)), 
             cast(b.BNFITAMT_5 as char(50)), 
             a.EMPLOYID, 
             'Benefit Tier Percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFTRMAX_1) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNFTRMAX_1', 
             getdate(), 
             cast(a.BNFTRMAX_1 as char(50)), 
             cast(b.BNFTRMAX_1 as char(50)), 
             a.EMPLOYID, 
             'Benefit Tier Percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFTRMAX_2) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNFTRMAX_2', 
             getdate(), 
             cast(a.BNFTRMAX_2 as char(50)), 
             cast(b.BNFTRMAX_2 as char(50)), 
             a.EMPLOYID, 
             'Benefit Tier Percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFTRMAX_3) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNFTRMAX_3', 
             getdate(), 
             cast(a.BNFTRMAX_3 as char(50)), 
             cast(b.BNFTRMAX_3 as char(50)), 
             a.EMPLOYID, 
             'Benefit Tier Percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFTRMAX_4) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNFTRMAX_4', 
             getdate(), 
             cast(a.BNFTRMAX_4 as char(50)), 
             cast(b.BNFTRMAX_4 as char(50)), 
             a.EMPLOYID, 
             'Benefit Tier Percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFTRMAX_5) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNFTRMAX_5', 
             getdate(), 
             cast(a.BNFTRMAX_5 as char(50)), 
             cast(b.BNFTRMAX_5 as char(50)), 
             a.EMPLOYID, 
             'Benefit Tier Percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNTRMXUN_1) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNTRMXUN_1', 
             getdate(), 
             cast(a.BNTRMXUN_1 as char(50)), 
             cast(b.BNTRMXUN_1 as char(50)), 
             a.EMPLOYID, 
             'Benefit Tier Percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNTRMXUN_2) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNTRMXUN_2', 
             getdate(), 
             cast(a.BNTRMXUN_2 as char(50)), 
             cast(b.BNTRMXUN_2 as char(50)), 
             a.EMPLOYID, 
             'Benefit Tier Percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNTRMXUN_3) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNTRMXUN_3', 
             getdate(), 
             cast(a.BNTRMXUN_3 as char(50)), 
             cast(b.BNTRMXUN_3 as char(50)), 
             a.EMPLOYID, 
             'Benefit Tier Percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNTRMXUN_4) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNTRMXUN_4', 
             getdate(), 
             cast(a.BNTRMXUN_4 as char(50)), 
             cast(b.BNTRMXUN_4 as char(50)), 
             a.EMPLOYID, 
             'Benefit Tier Percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNTRMXUN_5) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNTRMXUN_5', 
             getdate(), 
             cast(a.BNTRMXUN_5 as char(50)), 
             cast(b.BNTRMXUN_5 as char(50)), 
             a.EMPLOYID, 
             'Benefit Tier Percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNPAYPMX) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNPAYPMX', 
             getdate(), 
             cast(a.BNPAYPMX as char(50)), 
             cast(b.BNPAYPMX as char(50)), 
             a.EMPLOYID, 
             'Max Pay Period was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFYRMAX) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNFYRMAX', 
             getdate(), 
             cast(a.BNFYRMAX as char(50)), 
             cast(b.BNFYRMAX as char(50)), 
             a.EMPLOYID, 
             'Max Year was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFLFMAX) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'BNFLFMAX', 
             getdate(), 
             cast(a.BNFLFMAX as char(50)), 
             cast(b.BNFLFMAX as char(50)), 
             a.EMPLOYID, 
             'Lifetime max was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(W2BXNMBR) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'W2BXNMBR', 
             getdate(), 
             cast(a.W2BXNMBR as char(50)), 
             cast(b.W2BXNMBR as char(50)), 
             a.EMPLOYID, 
             'W-2 box was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(W2BXLABL) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'W2BXLABL', 
             getdate(), 
             cast(a.W2BXLABL as char(50)), 
             cast(b.W2BXLABL as char(50)), 
             a.EMPLOYID, 
             'W-2 Label was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(LTDBNFIT) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'LTDBNFIT', 
             getdate(), 
             cast(a.LTDBNFIT as char(50)), 
             cast(b.LTDBNFIT as char(50)), 
             a.EMPLOYID, 
             'Life To Date was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(DATAENTDFLT) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00600', 
             'DATAENTDFLT', 
             getdate(), 
             cast(a.DATAENTDFLT as char(50)), 
             cast(b.DATAENTDFLT as char(50)), 
             a.EMPLOYID, 
             'Data Entry Default was changed for benefit ' + rtrim(a.BENEFIT) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.BENEFIT = b.BENEFIT 
    end 

go 

if exists (select 1 
           from   sysobjects 
           where  name = 'trackBenefitAdditions' 
                  and type = 'tr') 
  drop trigger [trackBenefitAdditions] 

go 

create trigger [trackBenefitAdditions] 
on UPR00600 
for insert 
as 
  insert trackPayrollChanges 
  select system_user, 
         'UPR00600', 
         'Inserted Record', 
         getdate(), 
         'Inserted Record', 
         'Inserted Record', 
         EMPLOYID, 
         'Record with DEX_ROW_ID ' + rtrim(cast(DEX_ROW_ID as char(6))) + ' was added for employee ' + rtrim(EMPLOYID) + ' for benefit ' + rtrim(BENEFIT) 
  from   inserted 

go 

/*UPR00601*/ 
if exists (select 1 
           from   sysobjects 
           where  name = 'trackBenBasedOnAdditions' 
                  and type = 'tr') 
  drop trigger [trackBenBasedOnAdditions] 

go 

create trigger [trackBenBasedOnAdditions] 
on UPR00601 
for insert 
as 
  insert trackPayrollChanges 
  select system_user, 
         'UPR00601', 
         'Inserted Record', 
         getdate(), 
         'Inserted Record', 
         'Inserted Record', 
         EMPLOYID, 
         'Record with DEX_ROW_ID ' + rtrim(cast(DEX_ROW_ID as char(6))) + ' was added for employee ' + rtrim(EMPLOYID) + ' for benefit ' + rtrim(BENEFIT) 
  from   inserted 

go 

/*UPR00700*/ 
if exists (select 1 
           from   sysobjects 
           where  name = 'trackStateCodeChanges' 
                  and type = 'tr') 
  drop trigger [trackStateCodeChanges] 

go 

create trigger [trackStateCodeChanges] 
on UPR00700 
for update 
as 
  if update(TXFLGSTS) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00700', 
             'TXFLGSTS', 
             getdate(), 
             cast(a.TXFLGSTS as char(50)), 
             cast(b.TXFLGSTS as char(50)), 
             a.EMPLOYID, 
             'Tax Filing Status was changed for State Code ' + rtrim(a.STATECD) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.STATECD = b.STATECD 
    end 
   
  if update(EXMFBLND) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00700', 
             'EXMFBLND', 
             getdate(), 
             cast(a.EXMFBLND as char(50)), 
             cast(b.EXMFBLND as char(50)), 
             a.EMPLOYID, 
             'Exemption for Blind was changed for State Code ' + rtrim(a.STATECD) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.STATECD = b.STATECD 
    end 
   
  if update(EXFBLSPS) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00700', 
             'EXFBLSPS', 
             getdate(), 
             cast(a.EXFBLSPS as char(50)), 
             cast(b.EXFBLSPS as char(50)), 
             a.EMPLOYID, 
             'Exemption for Blind Spouse was changed for State Code ' + rtrim(a.STATECD) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.STATECD = b.STATECD 
    end 
   
  if update(EXFORO65) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00700', 
             'EXFORO65', 
             getdate(), 
             cast(a.EXFORO65 as char(50)), 
             cast(b.EXFORO65 as char(50)), 
             a.EMPLOYID, 
             'Exemption for Over 65 was changed for State Code ' + rtrim(a.STATECD) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.STATECD = b.STATECD 
    end 
   
  if update(EXMFRSLF) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00700', 
             'EXMFRSLF', 
             getdate(), 
             cast(a.EXMFRSLF as char(50)), 
             cast(b.EXMFRSLF as char(50)), 
             a.EMPLOYID, 
             'Exemption for Self was changed for State Code ' + rtrim(a.STATECD) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.STATECD = b.STATECD 
    end 
   
  if update(EXMFSPAL) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00700', 
             'EXMFSPAL', 
             getdate(), 
             cast(a.EXMFSPAL as char(50)), 
             cast(b.EXMFSPAL as char(50)), 
             a.EMPLOYID, 
             'Exemption for Special Allowance was changed for State Code ' + rtrim(a.STATECD) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.STATECD = b.STATECD 
    end 
   
  if update(EXMFRSPS) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00700', 
             'EXMFRSPS', 
             getdate(), 
             cast(a.EXMFRSPS as char(50)), 
             cast(b.EXMFRSPS as char(50)), 
             a.EMPLOYID, 
             'Exemption for Spouse was changed for State Code ' + rtrim(a.STATECD) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.STATECD = b.STATECD 
    end 
   
  if update(EXFSPO65) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00700', 
             'EXFSPO65', 
             getdate(), 
             cast(a.EXFSPO65 as char(50)), 
             cast(b.EXFSPO65 as char(50)), 
             a.EMPLOYID, 
             'Exemption for Spouse over 65 was changed for State Code ' + rtrim(a.STATECD) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.STATECD = b.STATECD 
    end 
   
  if update(PRSNEXPT) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00700', 
             'PRSNEXPT', 
             getdate(), 
             cast(a.PRSNEXPT as char(50)), 
             cast(b.PRSNEXPT as char(50)), 
             a.EMPLOYID, 
             'Personal Exemptions was changed for State Code ' + rtrim(a.STATECD) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.STATECD = b.STATECD 
    end 
   
  if update(DEPNDNTS) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00700', 
             'DEPNDNTS', 
             getdate(), 
             cast(a.DEPNDNTS as char(50)), 
             cast(b.DEPNDNTS as char(50)), 
             a.EMPLOYID, 
             'Dependents were changed for State Code ' + rtrim(a.STATECD) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.STATECD = b.STATECD 
    end 
   
  if update(ADNLALOW) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00700', 
             'ADNLALOW', 
             getdate(), 
             cast(a.ADNLALOW as char(50)), 
             cast(b.ADNLALOW as char(50)), 
             a.EMPLOYID, 
             'Additional Allowances were changed for State Code ' + rtrim(a.STATECD) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.STATECD = b.STATECD 
    end 
   
  if update(ESTDEDAL) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00700', 
             'ESTDEDAL', 
             getdate(), 
             cast(a.ESTDEDAL as char(50)), 
             cast(b.ESTDEDAL as char(50)), 
             a.EMPLOYID, 
             'Estimated State Withholding was changed for State Code ' + rtrim(a.STATECD) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.STATECD = b.STATECD 
    end 
   
  if update(EXMTAMNT) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00700', 
             'EXMTAMNT', 
             getdate(), 
             cast(a.EXMTAMNT as char(50)), 
             cast(b.EXMTAMNT as char(50)), 
             a.EMPLOYID, 
             'Exemption Amount was changed for State Code ' + rtrim(a.STATECD) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.STATECD = b.STATECD 
    end 
   
  if update(ADSTWHDG) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00700', 
             'ADSTWHDG', 
             getdate(), 
             cast(a.ADSTWHDG as char(50)), 
             cast(b.ADSTWHDG as char(50)), 
             a.EMPLOYID, 
             'Additional State Withholding was changed for State Code ' + rtrim(a.STATECD) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.STATECD = b.STATECD 
    end 
   
  if update(ESTSTWHD) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00700', 
             'ESTSTWHD', 
             getdate(), 
             cast(a.ESTSTWHD as char(50)), 
             cast(b.ESTSTWHD as char(50)), 
             a.EMPLOYID, 
             'Estimated State Withholding was changed for State Code ' + rtrim(a.STATECD) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.STATECD = b.STATECD 
    end 
   
  if update(INACTIVE) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00700', 
             'INACTIVE', 
             getdate(), 
             cast(a.INACTIVE as char(50)), 
             cast(b.INACTIVE as char(50)), 
             a.EMPLOYID, 
             'INACTIVE was changed for State Code ' + rtrim(a.STATECD) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.STATECD = b.STATECD 
    end 
   
  if update(NOTEINDX) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00700', 
             'NOTEINDX', 
             getdate(), 
             cast(a.NOTEINDX as char(50)), 
             cast(b.NOTEINDX as char(50)), 
             a.EMPLOYID, 
             'Note Index was changed for State Code ' + rtrim(a.STATECD) + ' for Employee ' + rtrim(a.EMPLOYID) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.STATECD = b.STATECD 
    end 

go 

if exists (select 1 
           from   sysobjects 
           where  name = 'trackStateTaxAdditions' 
                  and type = 'tr') 
  drop trigger [trackStateTaxAdditions] 

go 

create trigger [trackStateTaxAdditions] 
on UPR00700 
for insert 
as 
  insert trackPayrollChanges 
  select system_user, 
         'UPR00700', 
         'Inserted Record', 
         getdate(), 
         'Inserted Record', 
         'Inserted Record', 
         EMPLOYID, 
         'State Tax Code for Employee' + rtrim(EMPLOYID) + ' was added' 
  from   inserted 

go 

/*UPR00800*/ 
if exists (select 1 
           from   sysobjects 
           where  name = 'trackLocalTaxCodeChanges' 
                  and type = 'tr') 
  drop trigger [trackLocalTaxCodeChanges] 

go 

create trigger [trackLocalTaxCodeChanges] 
on UPR00800 
for update 
as 
  if update(LCLFGSTS) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00800', 
             'LCLFGSTS', 
             getdate(), 
             cast(a.LCLFGSTS as char(50)), 
             cast(b.LCLFGSTS as char(50)), 
             a.EMPLOYID, 
             'Local Filing Status  changed for Employee ' + rtrim(a.EMPLOYID) + ' for local tax code ' + rtrim(a.LOCALTAX) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.LOCALTAX = b.LOCALTAX 
    end 
   
  if update(AULCLTAX) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00800', 
             'AULCLTAX', 
             getdate(), 
             cast(a.AULCLTAX as char(50)), 
             cast(b.AULCLTAX as char(50)), 
             a.EMPLOYID, 
             'Automatic Local Tax changed for Employee ' + rtrim(a.EMPLOYID) + ' for local tax code ' + rtrim(a.LOCALTAX) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.LOCALTAX = b.LOCALTAX 
    end 
   
  if update(NUMOFEXM) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00800', 
             'NUMOFEXM', 
             getdate(), 
             cast(a.NUMOFEXM as char(50)), 
             cast(b.NUMOFEXM as char(50)), 
             a.EMPLOYID, 
             'Number of Exemptions changed for Employee ' + rtrim(a.EMPLOYID) + ' for local tax code ' + rtrim(a.LOCALTAX) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.LOCALTAX = b.LOCALTAX 
    end 
   
  if update(INACTIVE) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00800', 
             'INACTIVE', 
             getdate(), 
             cast(a.INACTIVE as char(50)), 
             cast(b.INACTIVE as char(50)), 
             a.EMPLOYID, 
             'Inactive changed for Employee ' + rtrim(a.EMPLOYID) + ' for local tax code ' + rtrim(a.LOCALTAX) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.LOCALTAX = b.LOCALTAX 
    end 
   
  if update(ADTLLOCWTHDNG) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00800', 
             'ADTLLOCWTHDNG', 
             getdate(), 
             cast(a.ADTLLOCWTHDNG as char(50)), 
             cast(b.ADTLLOCWTHDNG as char(50)), 
             a.EMPLOYID, 
             'Additional Local Withholding changed for Employee ' + rtrim(a.EMPLOYID) + ' for local tax code ' + rtrim(a.LOCALTAX) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.LOCALTAX = b.LOCALTAX 
    end 

go 

if exists (select 1 
           from   sysobjects 
           where  name = 'trackLocalTaxAdditions' 
                  and type = 'tr') 
  drop trigger [trackLocalTaxAdditions] 

go 

create trigger [trackLocalTaxAdditions] 
on UPR00800 
for insert 
as 
  insert trackPayrollChanges 
  select system_user, 
         'UPR00800', 
         'Inserted Record', 
         getdate(), 
         'Inserted Record', 
         'Inserted Record', 
         EMPLOYID, 
         'Local Tax Code for Employee' + rtrim(EMPLOYID) + ' was added' 
  from   inserted 

go 

/*UPR00900*/ 
if exists (select 1 
           from   sysobjects 
           where  name = 'trackEmployeeSummaryChanges' 
                  and type = 'tr') 
  drop trigger [trackEmployeeSummaryChanges] 

go 

create trigger [trackEmployeeSummaryChanges] 
on UPR00900 
for update 
as 
  if update(LPCHKNUM) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'LPCHKNUM', 
             getdate(), 
             cast(a.LPCHKNUM as char(50)), 
             cast(b.LPCHKNUM as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(LSTPCKDT) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'LSTPCKDT', 
             getdate(), 
             cast(a.LSTPCKDT as char(50)), 
             cast(b.LSTPCKDT as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(LPCHKAMT) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'LPCHKAMT', 
             getdate(), 
             cast(a.LPCHKAMT as char(50)), 
             cast(b.LPCHKAMT as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(GROSWAGS_1) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'GROSWAGS_1', 
             getdate(), 
             cast(a.GROSWAGS_1 as char(50)), 
             cast(b.GROSWAGS_1 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(GROSWAGS_2) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'GROSWAGS_2', 
             getdate(), 
             cast(a.GROSWAGS_2 as char(50)), 
             cast(b.GROSWAGS_2 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(GROSWAGS_3) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'GROSWAGS_3', 
             getdate(), 
             cast(a.GROSWAGS_3 as char(50)), 
             cast(b.GROSWAGS_3 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(GROSWAGS_4) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'GROSWAGS_4', 
             getdate(), 
             cast(a.GROSWAGS_4 as char(50)), 
             cast(b.GROSWAGS_4 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(GROSWAGS_5) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'GROSWAGS_5', 
             getdate(), 
             cast(a.GROSWAGS_5 as char(50)), 
             cast(b.GROSWAGS_5 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(GROSWAGS_6) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'GROSWAGS_6', 
             getdate(), 
             cast(a.GROSWAGS_6 as char(50)), 
             cast(b.GROSWAGS_6 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(GROSWAGS_7) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'GROSWAGS_7', 
             getdate(), 
             cast(a.GROSWAGS_7 as char(50)), 
             cast(b.GROSWAGS_7 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(GROSWAGS_8) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'GROSWAGS_8', 
             getdate(), 
             cast(a.GROSWAGS_8 as char(50)), 
             cast(b.GROSWAGS_8 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(GROSWAGS_9) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'GROSWAGS_9', 
             getdate(), 
             cast(a.GROSWAGS_9 as char(50)), 
             cast(b.GROSWAGS_9 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(GROSWAGS_10) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'GROSWAGS_10', 
             getdate(), 
             cast(a.GROSWAGS_10 as char(50)), 
             cast(b.GROSWAGS_10 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(GROSWAGS_11) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'GROSWAGS_11', 
             getdate(), 
             cast(a.GROSWAGS_11 as char(50)), 
             cast(b.GROSWAGS_11 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(GROSWAGS_12) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'GROSWAGS_12', 
             getdate(), 
             cast(a.GROSWAGS_12 as char(50)), 
             cast(b.GROSWAGS_12 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FDWTHLDG_1) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FDWTHLDG_1', 
             getdate(), 
             cast(a.FDWTHLDG_1 as char(50)), 
             cast(b.FDWTHLDG_1 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FDWTHLDG_2) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FDWTHLDG_2', 
             getdate(), 
             cast(a.FDWTHLDG_2 as char(50)), 
             cast(b.FDWTHLDG_2 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FDWTHLDG_3) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FDWTHLDG_3', 
             getdate(), 
             cast(a.FDWTHLDG_3 as char(50)), 
             cast(b.FDWTHLDG_3 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FDWTHLDG_4) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FDWTHLDG_4', 
             getdate(), 
             cast(a.FDWTHLDG_4 as char(50)), 
             cast(b.FDWTHLDG_4 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FDWTHLDG_5) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FDWTHLDG_5', 
             getdate(), 
             cast(a.FDWTHLDG_5 as char(50)), 
             cast(b.FDWTHLDG_5 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FDWTHLDG_6) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FDWTHLDG_6', 
             getdate(), 
             cast(a.FDWTHLDG_6 as char(50)), 
             cast(b.FDWTHLDG_6 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FDWTHLDG_7) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FDWTHLDG_7', 
             getdate(), 
             cast(a.FDWTHLDG_7 as char(50)), 
             cast(b.FDWTHLDG_7 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FDWTHLDG_8) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FDWTHLDG_8', 
             getdate(), 
             cast(a.FDWTHLDG_8 as char(50)), 
             cast(b.FDWTHLDG_8 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FDWTHLDG_9) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FDWTHLDG_9', 
             getdate(), 
             cast(a.FDWTHLDG_9 as char(50)), 
             cast(b.FDWTHLDG_9 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FDWTHLDG_10) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FDWTHLDG_10', 
             getdate(), 
             cast(a.FDWTHLDG_10 as char(50)), 
             cast(b.FDWTHLDG_10 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FDWTHLDG_11) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FDWTHLDG_11', 
             getdate(), 
             cast(a.FDWTHLDG_11 as char(50)), 
             cast(b.FDWTHLDG_11 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FDWTHLDG_12) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FDWTHLDG_12', 
             getdate(), 
             cast(a.FDWTHLDG_12 as char(50)), 
             cast(b.FDWTHLDG_12 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICASSWG_1) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICASSWG_1', 
             getdate(), 
             cast(a.FICASSWG_1 as char(50)), 
             cast(b.FICASSWG_1 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICASSWG_2) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICASSWG_2', 
             getdate(), 
             cast(a.FICASSWG_2 as char(50)), 
             cast(b.FICASSWG_2 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICASSWG_3) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICASSWG_3', 
             getdate(), 
             cast(a.FICASSWG_3 as char(50)), 
             cast(b.FICASSWG_3 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICASSWG_4) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICASSWG_4', 
             getdate(), 
             cast(a.FICASSWG_4 as char(50)), 
             cast(b.FICASSWG_4 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICASSWG_5) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICASSWG_5', 
             getdate(), 
             cast(a.FICASSWG_5 as char(50)), 
             cast(b.FICASSWG_5 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICASSWG_6) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICASSWG_6', 
             getdate(), 
             cast(a.FICASSWG_6 as char(50)), 
             cast(b.FICASSWG_6 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICASSWG_7) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICASSWG_7', 
             getdate(), 
             cast(a.FICASSWG_7 as char(50)), 
             cast(b.FICASSWG_7 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICASSWG_8) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICASSWG_8', 
             getdate(), 
             cast(a.FICASSWG_8 as char(50)), 
             cast(b.FICASSWG_8 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICASSWG_9) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICASSWG_9', 
             getdate(), 
             cast(a.FICASSWG_9 as char(50)), 
             cast(b.FICASSWG_9 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICASSWG_10) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICASSWG_10', 
             getdate(), 
             cast(a.FICASSWG_10 as char(50)), 
             cast(b.FICASSWG_10 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICASSWG_11) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICASSWG_11', 
             getdate(), 
             cast(a.FICASSWG_11 as char(50)), 
             cast(b.FICASSWG_11 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICASSWG_12) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICASSWG_12', 
             getdate(), 
             cast(a.FICASSWG_12 as char(50)), 
             cast(b.FICASSWG_12 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICAMWGS_1) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICAMWGS_1', 
             getdate(), 
             cast(a.FICAMWGS_1 as char(50)), 
             cast(b.FICAMWGS_1 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICAMWGS_2) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICAMWGS_2', 
             getdate(), 
             cast(a.FICAMWGS_2 as char(50)), 
             cast(b.FICAMWGS_2 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICAMWGS_3) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICAMWGS_3', 
             getdate(), 
             cast(a.FICAMWGS_3 as char(50)), 
             cast(b.FICAMWGS_3 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICAMWGS_4) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICAMWGS_4', 
             getdate(), 
             cast(a.FICAMWGS_4 as char(50)), 
             cast(b.FICAMWGS_4 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICAMWGS_5) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICAMWGS_5', 
             getdate(), 
             cast(a.FICAMWGS_5 as char(50)), 
             cast(b.FICAMWGS_5 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICAMWGS_6) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICAMWGS_6', 
             getdate(), 
             cast(a.FICAMWGS_6 as char(50)), 
             cast(b.FICAMWGS_6 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICAMWGS_7) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICAMWGS_7', 
             getdate(), 
             cast(a.FICAMWGS_7 as char(50)), 
             cast(b.FICAMWGS_7 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICAMWGS_8) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICAMWGS_8', 
             getdate(), 
             cast(a.FICAMWGS_8 as char(50)), 
             cast(b.FICAMWGS_8 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICAMWGS_9) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICAMWGS_9', 
             getdate(), 
             cast(a.FICAMWGS_9 as char(50)), 
             cast(b.FICAMWGS_9 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICAMWGS_10) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICAMWGS_10', 
             getdate(), 
             cast(a.FICAMWGS_10 as char(50)), 
             cast(b.FICAMWGS_10 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICAMWGS_11) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICAMWGS_11', 
             getdate(), 
             cast(a.FICAMWGS_11 as char(50)), 
             cast(b.FICAMWGS_11 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICAMWGS_12) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICAMWGS_12', 
             getdate(), 
             cast(a.FICAMWGS_12 as char(50)), 
             cast(b.FICAMWGS_12 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICASSWH_1) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICASSWH_1', 
             getdate(), 
             cast(a.FICASSWH_1 as char(50)), 
             cast(b.FICASSWH_1 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICASSWH_2) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICASSWH_2', 
             getdate(), 
             cast(a.FICASSWH_2 as char(50)), 
             cast(b.FICASSWH_2 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICASSWH_3) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICASSWH_3', 
             getdate(), 
             cast(a.FICASSWH_3 as char(50)), 
             cast(b.FICASSWH_3 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICASSWH_4) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICASSWH_4', 
             getdate(), 
             cast(a.FICASSWH_4 as char(50)), 
             cast(b.FICASSWH_4 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICASSWH_5) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICASSWH_5', 
             getdate(), 
             cast(a.FICASSWH_5 as char(50)), 
             cast(b.FICASSWH_5 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICASSWH_6) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICASSWH_6', 
             getdate(), 
             cast(a.FICASSWH_6 as char(50)), 
             cast(b.FICASSWH_6 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICASSWH_7) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICASSWH_7', 
             getdate(), 
             cast(a.FICASSWH_7 as char(50)), 
             cast(b.FICASSWH_7 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICASSWH_8) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICASSWH_8', 
             getdate(), 
             cast(a.FICASSWH_8 as char(50)), 
             cast(b.FICASSWH_8 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICASSWH_9) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICASSWH_9', 
             getdate(), 
             cast(a.FICASSWH_9 as char(50)), 
             cast(b.FICASSWH_9 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICASSWH_10) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICASSWH_10', 
             getdate(), 
             cast(a.FICASSWH_10 as char(50)), 
             cast(b.FICASSWH_10 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICASSWH_11) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICASSWH_11', 
             getdate(), 
             cast(a.FICASSWH_11 as char(50)), 
             cast(b.FICASSWH_11 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICASSWH_12) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICASSWH_12', 
             getdate(), 
             cast(a.FICASSWH_12 as char(50)), 
             cast(b.FICASSWH_12 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICAMWDG_1) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICAMWDG_1', 
             getdate(), 
             cast(a.FICAMWDG_1 as char(50)), 
             cast(b.FICAMWDG_1 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICAMWDG_2) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICAMWDG_2', 
             getdate(), 
             cast(a.FICAMWDG_2 as char(50)), 
             cast(b.FICAMWDG_2 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICAMWDG_3) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICAMWDG_3', 
             getdate(), 
             cast(a.FICAMWDG_3 as char(50)), 
             cast(b.FICAMWDG_3 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICAMWDG_4) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICAMWDG_4', 
             getdate(), 
             cast(a.FICAMWDG_4 as char(50)), 
             cast(b.FICAMWDG_4 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICAMWDG_5) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICAMWDG_5', 
             getdate(), 
             cast(a.FICAMWDG_5 as char(50)), 
             cast(b.FICAMWDG_5 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICAMWDG_6) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICAMWDG_6', 
             getdate(), 
             cast(a.FICAMWDG_6 as char(50)), 
             cast(b.FICAMWDG_6 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICAMWDG_7) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICAMWDG_7', 
             getdate(), 
             cast(a.FICAMWDG_7 as char(50)), 
             cast(b.FICAMWDG_7 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICAMWDG_8) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICAMWDG_8', 
             getdate(), 
             cast(a.FICAMWDG_8 as char(50)), 
             cast(b.FICAMWDG_8 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICAMWDG_9) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICAMWDG_9', 
             getdate(), 
             cast(a.FICAMWDG_9 as char(50)), 
             cast(b.FICAMWDG_9 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICAMWDG_10) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICAMWDG_10', 
             getdate(), 
             cast(a.FICAMWDG_10 as char(50)), 
             cast(b.FICAMWDG_10 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICAMWDG_11) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICAMWDG_11', 
             getdate(), 
             cast(a.FICAMWDG_11 as char(50)), 
             cast(b.FICAMWDG_11 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FICAMWDG_12) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FICAMWDG_12', 
             getdate(), 
             cast(a.FICAMWDG_12 as char(50)), 
             cast(b.FICAMWDG_12 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(SUTAWAGS_1) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'SUTAWAGS_1', 
             getdate(), 
             cast(a.SUTAWAGS_1 as char(50)), 
             cast(b.SUTAWAGS_1 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(SUTAWAGS_2) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'SUTAWAGS_2', 
             getdate(), 
             cast(a.SUTAWAGS_2 as char(50)), 
             cast(b.SUTAWAGS_2 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(SUTAWAGS_3) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'SUTAWAGS_3', 
             getdate(), 
             cast(a.SUTAWAGS_3 as char(50)), 
             cast(b.SUTAWAGS_3 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(SUTAWAGS_4) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'SUTAWAGS_4', 
             getdate(), 
             cast(a.SUTAWAGS_4 as char(50)), 
             cast(b.SUTAWAGS_4 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(SUTAWAGS_5) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'SUTAWAGS_5', 
             getdate(), 
             cast(a.SUTAWAGS_5 as char(50)), 
             cast(b.SUTAWAGS_5 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(SUTAWAGS_6) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'SUTAWAGS_6', 
             getdate(), 
             cast(a.SUTAWAGS_6 as char(50)), 
             cast(b.SUTAWAGS_6 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(SUTAWAGS_7) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'SUTAWAGS_7', 
             getdate(), 
             cast(a.SUTAWAGS_7 as char(50)), 
             cast(b.SUTAWAGS_7 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(SUTAWAGS_8) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'SUTAWAGS_8', 
             getdate(), 
             cast(a.SUTAWAGS_8 as char(50)), 
             cast(b.SUTAWAGS_8 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(SUTAWAGS_9) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'SUTAWAGS_9', 
             getdate(), 
             cast(a.SUTAWAGS_9 as char(50)), 
             cast(b.SUTAWAGS_9 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(SUTAWAGS_10) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'SUTAWAGS_10', 
             getdate(), 
             cast(a.SUTAWAGS_10 as char(50)), 
             cast(b.SUTAWAGS_10 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(SUTAWAGS_11) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'SUTAWAGS_11', 
             getdate(), 
             cast(a.SUTAWAGS_11 as char(50)), 
             cast(b.SUTAWAGS_11 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(SUTAWAGS_12) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'SUTAWAGS_12', 
             getdate(), 
             cast(a.SUTAWAGS_12 as char(50)), 
             cast(b.SUTAWAGS_12 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FUTAWAGS_1) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FUTAWAGS_1', 
             getdate(), 
             cast(a.FUTAWAGS_1 as char(50)), 
             cast(b.FUTAWAGS_1 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FUTAWAGS_2) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FUTAWAGS_2', 
             getdate(), 
             cast(a.FUTAWAGS_2 as char(50)), 
             cast(b.FUTAWAGS_2 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FUTAWAGS_3) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FUTAWAGS_3', 
             getdate(), 
             cast(a.FUTAWAGS_3 as char(50)), 
             cast(b.FUTAWAGS_3 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FUTAWAGS_4) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FUTAWAGS_4', 
             getdate(), 
             cast(a.FUTAWAGS_4 as char(50)), 
             cast(b.FUTAWAGS_4 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FUTAWAGS_5) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FUTAWAGS_5', 
             getdate(), 
             cast(a.FUTAWAGS_5 as char(50)), 
             cast(b.FUTAWAGS_5 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FUTAWAGS_6) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FUTAWAGS_6', 
             getdate(), 
             cast(a.FUTAWAGS_6 as char(50)), 
             cast(b.FUTAWAGS_6 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FUTAWAGS_7) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FUTAWAGS_7', 
             getdate(), 
             cast(a.FUTAWAGS_7 as char(50)), 
             cast(b.FUTAWAGS_7 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FUTAWAGS_8) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FUTAWAGS_8', 
             getdate(), 
             cast(a.FUTAWAGS_8 as char(50)), 
             cast(b.FUTAWAGS_8 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FUTAWAGS_9) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FUTAWAGS_9', 
             getdate(), 
             cast(a.FUTAWAGS_9 as char(50)), 
             cast(b.FUTAWAGS_9 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FUTAWAGS_10) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FUTAWAGS_10', 
             getdate(), 
             cast(a.FUTAWAGS_10 as char(50)), 
             cast(b.FUTAWAGS_10 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FUTAWAGS_11) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FUTAWAGS_11', 
             getdate(), 
             cast(a.FUTAWAGS_11 as char(50)), 
             cast(b.FUTAWAGS_11 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(FUTAWAGS_12) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'FUTAWAGS_12', 
             getdate(), 
             cast(a.FUTAWAGS_12 as char(50)), 
             cast(b.FUTAWAGS_12 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(NETWAGES_1) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'NETWAGES_1', 
             getdate(), 
             cast(a.NETWAGES_1 as char(50)), 
             cast(b.NETWAGES_1 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(NETWAGES_2) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'NETWAGES_2', 
             getdate(), 
             cast(a.NETWAGES_2 as char(50)), 
             cast(b.NETWAGES_2 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(NETWAGES_3) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'NETWAGES_3', 
             getdate(), 
             cast(a.NETWAGES_3 as char(50)), 
             cast(b.NETWAGES_3 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(NETWAGES_4) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'NETWAGES_4', 
             getdate(), 
             cast(a.NETWAGES_4 as char(50)), 
             cast(b.NETWAGES_4 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(NETWAGES_5) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'NETWAGES_5', 
             getdate(), 
             cast(a.NETWAGES_5 as char(50)), 
             cast(b.NETWAGES_5 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(NETWAGES_6) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'NETWAGES_6', 
             getdate(), 
             cast(a.NETWAGES_6 as char(50)), 
             cast(b.NETWAGES_6 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(NETWAGES_7) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'NETWAGES_7', 
             getdate(), 
             cast(a.NETWAGES_7 as char(50)), 
             cast(b.NETWAGES_7 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(NETWAGES_8) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'NETWAGES_8', 
             getdate(), 
             cast(a.NETWAGES_8 as char(50)), 
             cast(b.NETWAGES_8 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(NETWAGES_9) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'NETWAGES_9', 
             getdate(), 
             cast(a.NETWAGES_9 as char(50)), 
             cast(b.NETWAGES_9 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(NETWAGES_10) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'NETWAGES_10', 
             getdate(), 
             cast(a.NETWAGES_10 as char(50)), 
             cast(b.NETWAGES_10 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(NETWAGES_11) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'NETWAGES_11', 
             getdate(), 
             cast(a.NETWAGES_11 as char(50)), 
             cast(b.NETWAGES_11 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(NETWAGES_12) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'NETWAGES_12', 
             getdate(), 
             cast(a.NETWAGES_12 as char(50)), 
             cast(b.NETWAGES_12 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(Federal_Wages_1) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'Federal_Wages_1', 
             getdate(), 
             cast(a.Federal_Wages_1 as char(50)), 
             cast(b.Federal_Wages_1 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(Federal_Wages_2) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'Federal_Wages_2', 
             getdate(), 
             cast(a.Federal_Wages_2 as char(50)), 
             cast(b.Federal_Wages_2 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(Federal_Wages_3) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'Federal_Wages_3', 
             getdate(), 
             cast(a.Federal_Wages_3 as char(50)), 
             cast(b.Federal_Wages_3 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(Federal_Wages_4) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'Federal_Wages_4', 
             getdate(), 
             cast(a.Federal_Wages_4 as char(50)), 
             cast(b.Federal_Wages_4 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(Federal_Wages_5) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'Federal_Wages_5', 
             getdate(), 
             cast(a.Federal_Wages_5 as char(50)), 
             cast(b.Federal_Wages_5 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(Federal_Wages_6) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'Federal_Wages_6', 
             getdate(), 
             cast(a.Federal_Wages_6 as char(50)), 
             cast(b.Federal_Wages_6 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(Federal_Wages_7) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'Federal_Wages_7', 
             getdate(), 
             cast(a.Federal_Wages_7 as char(50)), 
             cast(b.Federal_Wages_7 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(Federal_Wages_8) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'Federal_Wages_8', 
             getdate(), 
             cast(a.Federal_Wages_8 as char(50)), 
             cast(b.Federal_Wages_8 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(Federal_Wages_9) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'Federal_Wages_9', 
             getdate(), 
             cast(a.Federal_Wages_9 as char(50)), 
             cast(b.Federal_Wages_9 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(Federal_Wages_10) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'Federal_Wages_10', 
             getdate(), 
             cast(a.Federal_Wages_10 as char(50)), 
             cast(b.Federal_Wages_10 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(Federal_Wages_11) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'Federal_Wages_11', 
             getdate(), 
             cast(a.Federal_Wages_11 as char(50)), 
             cast(b.Federal_Wages_11 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 
     
  if update(Federal_Wages_12) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00900', 
             'Federal_Wages_12', 
             getdate(), 
             cast(a.Federal_Wages_12 as char(50)), 
             cast(b.Federal_Wages_12 as char(50)), 
             a.EMPLOYID, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.YEAR1 = b.YEAR1 
    end 

go 

if exists (select 1 
           from   sysobjects 
           where  name = 'trackEmpSummaryAdditions' 
                  and type = 'tr') 
  drop trigger [trackEmpSummaryAdditions] 

go 

create trigger [trackEmpSummaryAdditions] 
on UPR00900 
for insert 
as 
  insert trackPayrollChanges 
  select system_user, 
         'UPR00900', 
         'Inserted Record', 
         getdate(), 
         'Inserted Record', 
         'Inserted Record', 
         EMPLOYID, 
         'Record with DEX_ROW_ID ' + rtrim(cast(DEX_ROW_ID as char(6))) + ' was added for employee ' + rtrim(EMPLOYID) 
  from   inserted 

go 

/*BE010130*/ 
if exists (select 1 
           from   sysobjects 
           where  name = 'trackHRBenefitChanges' 
                  and type = 'tr') 
  drop trigger [trackHRBenefitChanges] 

go 

create trigger [trackHRBenefitChanges] 
on BE010130 
for update 
as 
  if update(BENEFITTYPE_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'BENEFITTYPE_I', 
             getdate(), 
             cast(a.BENEFITTYPE_I as char(50)), 
             cast(b.BENEFITTYPE_I as char(50)), 
             a.EMPID_I, 
             'Benefit type was updated for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(IINDEX_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'IINDEX_I', 
             getdate(), 
             cast(a.IINDEX_I as char(50)), 
             cast(b.IINDEX_I as char(50)), 
             a.EMPID_I, 
             'Index was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BENEFITKIND_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'BENEFITKIND_I', 
             getdate(), 
             cast(a.BENEFITKIND_I as char(50)), 
             cast(b.BENEFITKIND_I as char(50)), 
             a.EMPID_I, 
             'Benefit Kind was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(COMPLETIONSTATUS_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'COMPLETIONSTATUS_I', 
             getdate(), 
             cast(a.COMPLETIONSTATUS_I as char(50)), 
             cast(b.COMPLETIONSTATUS_I as char(50)), 
             a.EMPID_I, 
             'Completion status was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(POLICYNUMBER_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'POLICYNUMBER_I', 
             getdate(), 
             cast(a.POLICYNUMBER_I as char(50)), 
             cast(b.POLICYNUMBER_I as char(50)), 
             a.EMPID_I, 
             'Policy Number was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BENEFITSTATUS_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'BENEFITSTATUS_I', 
             getdate(), 
             cast(a.BENEFITSTATUS_I as char(50)), 
             cast(b.BENEFITSTATUS_I as char(50)), 
             a.EMPID_I, 
             'Benefit Status was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(INACTIVE) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'INACTIVE', 
             getdate(), 
             cast(a.INACTIVE as char(50)), 
             cast(b.INACTIVE as char(50)), 
             a.EMPID_I, 
             'Activation was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(OVERRIDE_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'OVERRIDE_I', 
             getdate(), 
             cast(a.OVERRIDE_I as char(50)), 
             cast(b.OVERRIDE_I as char(50)), 
             a.EMPID_I, 
             'Override was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(CHECK1_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'CHECK1_I', 
             getdate(), 
             cast(a.CHECK1_I as char(50)), 
             cast(b.CHECK1_I as char(50)), 
             a.EMPID_I, 
             'Check box was changed on HR Benefit Palette for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(CHECK2_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'CHECK2_I', 
             getdate(), 
             cast(a.CHECK2_I as char(50)), 
             cast(b.CHECK2_I as char(50)), 
             a.EMPID_I, 
             'Check box was changed on HR Benefit Palette for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(CHECK3_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'CHECK3_I', 
             getdate(), 
             cast(a.CHECK3_I as char(50)), 
             cast(b.CHECK3_I as char(50)), 
             a.EMPID_I, 
             'Check box was changed on HR Benefit Palette for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(CHECK4_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'CHECK4_I', 
             getdate(), 
             cast(a.CHECK4_I as char(50)), 
             cast(b.CHECK4_I as char(50)), 
             a.EMPID_I, 
             'Check box was changed on HR Benefit Palette for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(CHECK5_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'CHECK5_I', 
             getdate(), 
             cast(a.CHECK5_I as char(50)), 
             cast(b.CHECK5_I as char(50)), 
             a.EMPID_I, 
             'Check box was changed on HR Benefit Palette for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(DATEDUE_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'DATEDUE_I', 
             getdate(), 
             cast(a.DATEDUE_I as char(50)), 
             cast(b.DATEDUE_I as char(50)), 
             a.EMPID_I, 
             'Due Date was changed for Benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(DSCRIPTN) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'DSCRIPTN', 
             getdate(), 
             cast(a.DSCRIPTN as char(50)), 
             cast(b.DSCRIPTN as char(50)), 
             a.EMPID_I, 
             'Description was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(COMMENTSTR10_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'COMMENTSTR10_I', 
             getdate(), 
             cast(a.COMMENTSTR10_I as char(50)), 
             cast(b.COMMENTSTR10_I as char(50)), 
             a.EMPID_I, 
             'Comments were changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(IBENEFITAMOUNT_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'IBENEFITAMOUNT_I', 
             getdate(), 
             cast(a.IBENEFITAMOUNT_I as char(50)), 
             cast(b.IBENEFITAMOUNT_I as char(50)), 
             a.EMPID_I, 
             'Benefit Amount was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(LIFEAMTEMPL_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'LIFEAMTEMPL_I', 
             getdate(), 
             cast(a.LIFEAMTEMPL_I as char(50)), 
             cast(b.LIFEAMTEMPL_I as char(50)), 
             a.EMPID_I, 
             'Life Employee Amount was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(LIFEAMTSPOUSE_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'LIFEAMTSPOUSE_I', 
             getdate(), 
             cast(a.LIFEAMTSPOUSE_I as char(50)), 
             cast(b.LIFEAMTSPOUSE_I as char(50)), 
             a.EMPID_I, 
             'Spouse''s Life Amount was updated for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(LIFEAMTCHILDREN_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'LIFEAMTCHILDREN_I', 
             getdate(), 
             cast(a.LIFEAMTCHILDREN_I as char(50)), 
             cast(b.LIFEAMTCHILDREN_I as char(50)), 
             a.EMPID_I, 
             'Children''s Life Amount was updated for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BENELIGIBILEDATE_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'BENELIGIBILEDATE_I', 
             getdate(), 
             cast(a.BENELIGIBILEDATE_I as char(50)), 
             cast(b.BENELIGIBILEDATE_I as char(50)), 
             a.EMPID_I, 
             'Benefit Eligibility Date was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFBEGDT) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'BNFBEGDT', 
             getdate(), 
             cast(a.BNFBEGDT as char(50)), 
             cast(b.BNFBEGDT as char(50)), 
             a.EMPID_I, 
             'Benefit begin date was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFENDDT) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'BNFENDDT', 
             getdate(), 
             cast(a.BNFENDDT as char(50)), 
             cast(b.BNFENDDT as char(50)), 
             a.EMPID_I, 
             'Benefit End Date was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(VARBENFT) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'VARBENFT', 
             getdate(), 
             cast(a.VARBENFT as char(50)), 
             cast(b.VARBENFT as char(50)), 
             a.EMPID_I, 
             'Variable benefits has been updated for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFTFREQ) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'BNFTFREQ', 
             getdate(), 
             cast(a.BNFTFREQ as char(50)), 
             cast(b.BNFTFREQ as char(50)), 
             a.EMPID_I, 
             'Benefit Frequency was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(COSTEMPLOYEE_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'COSTEMPLOYEE_I', 
             getdate(), 
             cast(a.COSTEMPLOYEE_I as char(50)), 
             cast(b.COSTEMPLOYEE_I as char(50)), 
             a.EMPID_I, 
             'Default cost for the employee was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(COSTEMPLOYER_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'COSTEMPLOYER_I', 
             getdate(), 
             cast(a.COSTEMPLOYER_I as char(50)), 
             cast(b.COSTEMPLOYER_I as char(50)), 
             a.EMPID_I, 
             'Default cost for the employer was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(COSTOTHER1_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'COSTOTHER1_I', 
             getdate(), 
             cast(a.COSTOTHER1_I as char(50)), 
             cast(b.COSTOTHER1_I as char(50)), 
             a.EMPID_I, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(COSTOTHER2_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'COSTOTHER2_I', 
             getdate(), 
             cast(a.COSTOTHER2_I as char(50)), 
             cast(b.COSTOTHER2_I as char(50)), 
             a.EMPID_I, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(I1_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'I1_I', 
             getdate(), 
             cast(a.I1_I as char(50)), 
             cast(b.I1_I as char(50)), 
             a.EMPID_I, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(I2_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'I2_I', 
             getdate(), 
             cast(a.I2_I as char(50)), 
             cast(b.I2_I as char(50)), 
             a.EMPID_I, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(I3_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'I3_I', 
             getdate(), 
             cast(a.I3_I as char(50)), 
             cast(b.I3_I as char(50)), 
             a.EMPID_I, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(I4_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'I4_I', 
             getdate(), 
             cast(a.I4_I as char(50)), 
             cast(b.I4_I as char(50)), 
             a.EMPID_I, 
             'Smoking preference was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(NUMBEROFCHILDREN_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'NUMBEROFCHILDREN_I', 
             getdate(), 
             cast(a.NUMBEROFCHILDREN_I as char(50)), 
             cast(b.NUMBEROFCHILDREN_I as char(50)), 
             a.EMPID_I, 
             'Number of children was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(COSTTOTAL_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'COSTTOTAL_I', 
             getdate(), 
             cast(a.COSTTOTAL_I as char(50)), 
             cast(b.COSTTOTAL_I as char(50)), 
             a.EMPID_I, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(COSTCOBRA_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'COSTCOBRA_I', 
             getdate(), 
             cast(a.COSTCOBRA_I as char(50)), 
             cast(b.COSTCOBRA_I as char(50)), 
             a.EMPID_I, 
             'Amount to receive COBRA benefits was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BENEFITDEDUCTIBLE_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'BENEFITDEDUCTIBLE_I', 
             getdate(), 
             cast(a.BENEFITDEDUCTIBLE_I as char(50)), 
             cast(b.BENEFITDEDUCTIBLE_I as char(50)), 
             a.EMPID_I, 
             'Deductible amount was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNPAYPMX) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'BNPAYPMX', 
             getdate(), 
             cast(a.BNPAYPMX as char(50)), 
             cast(b.BNPAYPMX as char(50)), 
             a.EMPID_I, 
             'Benefit pay period max was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFYRMAX) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'BNFYRMAX', 
             getdate(), 
             cast(a.BNFYRMAX as char(50)), 
             cast(b.BNFYRMAX as char(50)), 
             a.EMPID_I, 
             'Benefit Year Max was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFLFMAX) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'BNFLFMAX', 
             getdate(), 
             cast(a.BNFLFMAX as char(50)), 
             cast(b.BNFLFMAX as char(50)), 
             a.EMPID_I, 
             'Benefit Lifetime Max was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BENEFICIARYINDEX_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'BENEFICIARYINDEX_I', 
             getdate(), 
             cast(a.BENEFICIARYINDEX_I as char(50)), 
             cast(b.BENEFICIARYINDEX_I as char(50)), 
             a.EMPID_I, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(CHANGEBY_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'CHANGEBY_I', 
             getdate(), 
             cast(a.CHANGEBY_I as char(50)), 
             cast(b.CHANGEBY_I as char(50)), 
             a.EMPID_I, 
             'User who last saved this record was changed by ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(CHANGEDATE_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'CHANGEDATE_I', 
             getdate(), 
             cast(a.CHANGEDATE_I as char(50)), 
             cast(b.CHANGEDATE_I as char(50)), 
             a.EMPID_I, 
             'Date this record was changed was changed by ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(CONTRIBPRETAX_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'CONTRIBPRETAX_I', 
             getdate(), 
             cast(a.CONTRIBPRETAX_I as char(50)), 
             cast(b.CONTRIBPRETAX_I as char(50)), 
             a.EMPID_I, 
             'Pre-tax percentage for retirement was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(CONTPRETAXDLR_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'CONTPRETAXDLR_I', 
             getdate(), 
             cast(a.CONTPRETAXDLR_I as char(50)), 
             cast(b.CONTPRETAXDLR_I as char(50)), 
             a.EMPID_I, 
             'Pre-tax dollar amount for retirement was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(CONTRIBAFTERTAX_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'CONTRIBAFTERTAX_I', 
             getdate(), 
             cast(a.CONTRIBAFTERTAX_I as char(50)), 
             cast(b.CONTRIBAFTERTAX_I as char(50)), 
             a.EMPID_I, 
             'After tax percentage for retirement was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(CONTAFTERTAXDLR_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'CONTAFTERTAXDLR_I', 
             getdate(), 
             cast(a.CONTAFTERTAXDLR_I as char(50)), 
             cast(b.CONTAFTERTAXDLR_I as char(50)), 
             a.EMPID_I, 
             'After tax dollar amount was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(CONTRIBBONUS_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'CONTRIBBONUS_I', 
             getdate(), 
             cast(a.CONTRIBBONUS_I as char(50)), 
             cast(b.CONTRIBBONUS_I as char(50)), 
             a.EMPID_I, 
             'Pre-tax bonus percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(CONTRIBBONUSDOLLAR_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'CONTRIBBONUSDOLLAR_I', 
             getdate(), 
             cast(a.CONTRIBBONUSDOLLAR_I as char(50)), 
             cast(b.CONTRIBBONUSDOLLAR_I as char(50)), 
             a.EMPID_I, 
             'Pre-tax bonus dollar amount was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(HIGHLYCOMPENSATED_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'HIGHLYCOMPENSATED_I', 
             getdate(), 
             cast(a.HIGHLYCOMPENSATED_I as char(50)), 
             cast(b.HIGHLYCOMPENSATED_I as char(50)), 
             a.EMPID_I, 
             'High paid employee was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(LOANACTIVE_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'LOANACTIVE_I', 
             getdate(), 
             cast(a.LOANACTIVE_I as char(50)), 
             cast(b.LOANACTIVE_I as char(50)), 
             a.EMPID_I, 
             'Loan active was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(TYPEOFCODE_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'TYPEOFCODE_I', 
             getdate(), 
             cast(a.TYPEOFCODE_I as char(50)), 
             cast(b.TYPEOFCODE_I as char(50)), 
             a.EMPID_I, 
             'Code type was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(TIERSUSED_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'TIERSUSED_I', 
             getdate(), 
             cast(a.TIERSUSED_I as char(50)), 
             cast(b.TIERSUSED_I as char(50)), 
             a.EMPID_I, 
             'Tiers used was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(MAJMEDCOVERAGE_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'MAJMEDCOVERAGE_I', 
             getdate(), 
             cast(a.MAJMEDCOVERAGE_I as char(50)), 
             cast(b.MAJMEDCOVERAGE_I as char(50)), 
             a.EMPID_I, 
             'Major Medical Coverage was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(MAXOUTOFPOCKET_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'MAXOUTOFPOCKET_I', 
             getdate(), 
             cast(a.MAXOUTOFPOCKET_I as char(50)), 
             cast(b.MAXOUTOFPOCKET_I as char(50)), 
             a.EMPID_I, 
             'Max Out of Pocket was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(ELIGIBILITYDATE_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'ELIGIBILITYDATE_I', 
             getdate(), 
             cast(a.ELIGIBILITYDATE_I as char(50)), 
             cast(b.ELIGIBILITYDATE_I as char(50)), 
             a.EMPID_I, 
             'Benefit eligibility date was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(PRIMARYBENEFICIARY_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'PRIMARYBENEFICIARY_I', 
             getdate(), 
             cast(a.PRIMARYBENEFICIARY_I as char(50)), 
             cast(b.PRIMARYBENEFICIARY_I as char(50)), 
             a.EMPID_I, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(SECBENEFICIARY_I) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'SECBENEFICIARY_I', 
             getdate(), 
             cast(a.SECBENEFICIARY_I as char(50)), 
             cast(b.SECBENEFICIARY_I as char(50)), 
             a.EMPID_I, 
             '' 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFTMTHD) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'BNFTMTHD', 
             getdate(), 
             cast(a.BNFTMTHD as char(50)), 
             cast(b.BNFTMTHD as char(50)), 
             a.EMPID_I, 
             'Benefit method was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFFRMLA) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'BNFFRMLA', 
             getdate(), 
             cast(a.BNFFRMLA as char(50)), 
             cast(b.BNFFRMLA as char(50)), 
             a.EMPID_I, 
             'Benefit formula was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFPRCNT_1) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'BNFPRCNT_1', 
             getdate(), 
             cast(a.BNFPRCNT_1 as char(50)), 
             cast(b.BNFPRCNT_1 as char(50)), 
             a.EMPID_I, 
             'Benefit percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFPRCNT_2) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'BNFPRCNT_2', 
             getdate(), 
             cast(a.BNFPRCNT_2 as char(50)), 
             cast(b.BNFPRCNT_2 as char(50)), 
             a.EMPID_I, 
             'Benefit percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFPRCNT_3) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'BNFPRCNT_3', 
             getdate(), 
             cast(a.BNFPRCNT_3 as char(50)), 
             cast(b.BNFPRCNT_3 as char(50)), 
             a.EMPID_I, 
             'Benefit percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFPRCNT_4) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'BNFPRCNT_4', 
             getdate(), 
             cast(a.BNFPRCNT_4 as char(50)), 
             cast(b.BNFPRCNT_4 as char(50)), 
             a.EMPID_I, 
             'Benefit percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(BNFPRCNT_5) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'BNFPRCNT_5', 
             getdate(), 
             cast(a.BNFPRCNT_5 as char(50)), 
             cast(b.BNFPRCNT_5 as char(50)), 
             a.EMPID_I, 
             'Benefit percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(DEDNMTHD) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'DEDNMTHD', 
             getdate(), 
             cast(a.DEDNMTHD as char(50)), 
             cast(b.DEDNMTHD as char(50)), 
             a.EMPID_I, 
             'Deduction method was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(DEDFRMLA) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'DEDFRMLA', 
             getdate(), 
             cast(a.DEDFRMLA as char(50)), 
             cast(b.DEDFRMLA as char(50)), 
             a.EMPID_I, 
             'Deduction formula was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(DEDNPRCT_1) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'DEDNPRCT_1', 
             getdate(), 
             cast(a.DEDNPRCT_1 as char(50)), 
             cast(b.DEDNPRCT_1 as char(50)), 
             a.EMPID_I, 
             'Deduction Percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(DEDNPRCT_2) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'DEDNPRCT_2', 
             getdate(), 
             cast(a.DEDNPRCT_2 as char(50)), 
             cast(b.DEDNPRCT_2 as char(50)), 
             a.EMPID_I, 
             'Deduction Percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(DEDNPRCT_3) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'DEDNPRCT_3', 
             getdate(), 
             cast(a.DEDNPRCT_3 as char(50)), 
             cast(b.DEDNPRCT_3 as char(50)), 
             a.EMPID_I, 
             'Deduction Percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(DEDNPRCT_4) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'DEDNPRCT_4', 
             getdate(), 
             cast(a.DEDNPRCT_4 as char(50)), 
             cast(b.DEDNPRCT_4 as char(50)), 
             a.EMPID_I, 
             'Deduction Percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(DEDNPRCT_5) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'DEDNPRCT_5', 
             getdate(), 
             cast(a.DEDNPRCT_5 as char(50)), 
             cast(b.DEDNPRCT_5 as char(50)), 
             a.EMPID_I, 
             'Deduction Percentage was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(DEPYPRMX) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'DEPYPRMX', 
             getdate(), 
             cast(a.DEPYPRMX as char(50)), 
             cast(b.DEPYPRMX as char(50)), 
             a.EMPID_I, 
             'Deduction Pay Period Max was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(DEDYRMAX) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'DEDYRMAX', 
             getdate(), 
             cast(a.DEDYRMAX as char(50)), 
             cast(b.DEDYRMAX as char(50)), 
             a.EMPID_I, 
             'Max Yearly deduction was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(DEDLTMAX) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'DEDLTMAX', 
             getdate(), 
             cast(a.DEDLTMAX as char(50)), 
             cast(b.DEDLTMAX as char(50)), 
             a.EMPID_I, 
             'Lifetime max deduction was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(DEDINITBAL) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'DEDINITBAL', 
             getdate(), 
             cast(a.DEDINITBAL as char(50)), 
             cast(b.DEDINITBAL as char(50)), 
             a.EMPID_I, 
             'Deduction initial balance was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(INACTBENEMPLOYEE) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'INACTBENEMPLOYEE', 
             getdate(), 
             cast(a.INACTBENEMPLOYEE as char(50)), 
             cast(b.INACTBENEMPLOYEE as char(50)), 
             a.EMPID_I, 
             'Employee active benefit was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 
     
  if update(INACTBENEMPLR) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'BE010130', 
             'INACTBENEMPLR', 
             getdate(), 
             cast(a.INACTBENEMPLR as char(50)), 
             cast(b.INACTBENEMPLR as char(50)), 
             a.EMPID_I, 
             'Employer active benefit was changed for benefit ' + rtrim(a.BENEFIT) + ' for employee ' + rtrim(a.EMPID_I) 
      from   deleted a 
             inner join inserted b 
               on a.EMPID_I = b.EMPID_I 
                  and a.BENEFIT = b.BENEFIT 
    end 

go 

if exists (select 1 
           from   sysobjects 
           where  name = 'trackHRBenefitAdditions' 
                  and type = 'tr') 
  drop trigger [trackHRBenefitAdditions] 

go 

create trigger [trackHRBenefitAdditions] 
on BE010130 
for insert 
as 
  insert trackPayrollChanges 
  select system_user, 
         'BE010130', 
         'Inserted Record', 
         getdate(), 
         'Inserted Record', 
         'Inserted Record', 
         EMPID_I, 
         'Record with DEX_ROW_ID ' + rtrim(cast(DEX_ROW_ID as char(6))) + ' was added for employee ' + rtrim(EMPID_I) + ' for benefit ' + rtrim(BENEFIT) 
  from   inserted 

go 

/*UPR00102*/ 
if exists (select 1 
           from   sysobjects 
           where  name = 'trackAddressChanges' 
                  and type = 'tr') 
  drop trigger trackAddressChanges 

go 

create trigger [trackAddressChanges] 
on UPR00102 
for update 
as 
  if update(ADDRESS1) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00102', 
             'ADDRESS1', 
             getdate(), 
             cast(a.ADDRESS1 as char(50)), 
             cast(b.ADDRESS1 as char(50)), 
             a.EMPLOYID, 
             'Address1 changed for employee ' + rtrim(a.EMPLOYID) + ' for address code ' + rtrim(a.ADRSCODE) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.ADRSCODE = b.ADRSCODE 
    end 
   
  if update(ADDRESS2) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00102', 
             'ADDRESS2', 
             getdate(), 
             cast(a.ADDRESS2 as char(50)), 
             cast(b.ADDRESS2 as char(50)), 
             a.EMPLOYID, 
             'Address2 changed for employee ' + rtrim(a.EMPLOYID) + ' for address code ' + rtrim(a.ADRSCODE) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.ADRSCODE = b.ADRSCODE 
    end 
   
  if update(ADDRESS3) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00102', 
             'ADDRESS3', 
             getdate(), 
             cast(a.ADDRESS3 as char(50)), 
             cast(b.ADDRESS3 as char(50)), 
             a.EMPLOYID, 
             'Address3 changed for employee ' + rtrim(a.EMPLOYID) + ' for address code ' + rtrim(a.ADRSCODE) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.ADRSCODE = b.ADRSCODE 
    end 
   
  if update(CITY) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00102', 
             'CITY', 
             getdate(), 
             cast(a.CITY as char(50)), 
             cast(b.CITY as char(50)), 
             a.EMPLOYID, 
             'City changed for employee ' + rtrim(a.EMPLOYID) + ' for City code ' + rtrim(a.ADRSCODE) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.ADRSCODE = b.ADRSCODE 
    end 
   
  if update(STATE) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00102', 
             'STATE', 
             getdate(), 
             cast(a.STATE as char(50)), 
             cast(b.STATE as char(50)), 
             a.EMPLOYID, 
             'State changed for employee ' + rtrim(a.EMPLOYID) + ' for State code ' + rtrim(a.ADRSCODE) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.ADRSCODE = b.ADRSCODE 
    end 
   
  if update(ZIPCODE) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00102', 
             'ZIPCODE', 
             getdate(), 
             cast(a.ZIPCODE as char(50)), 
             cast(b.ZIPCODE as char(50)), 
             a.EMPLOYID, 
             'Zip Code changed for employee ' + rtrim(a.EMPLOYID) + ' for Zip Code code ' + rtrim(a.ADRSCODE) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.ADRSCODE = b.ADRSCODE 
    end 
   
  if update(COUNTY) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00102', 
             'COUNTY', 
             getdate(), 
             cast(a.COUNTY as char(50)), 
             cast(b.COUNTY as char(50)), 
             a.EMPLOYID, 
             'County changed for employee ' + rtrim(a.EMPLOYID) + ' for County code ' + rtrim(a.ADRSCODE) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.ADRSCODE = b.ADRSCODE 
    end 
   
  if update(COUNTRY) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00102', 
             'COUNTRY', 
             getdate(), 
             cast(a.COUNTRY as char(50)), 
             cast(b.COUNTRY as char(50)), 
             a.EMPLOYID, 
             'Country changed for employee ' + rtrim(a.EMPLOYID) + ' for Coountry code ' + rtrim(a.ADRSCODE) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.ADRSCODE = b.ADRSCODE 
    end 
   
  if update(PHONE1) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00102', 
             'PHONE1', 
             getdate(), 
             cast(a.PHONE1 as char(50)), 
             cast(b.PHONE1 as char(50)), 
             a.EMPLOYID, 
             'Phone1 changed for employee ' + rtrim(a.EMPLOYID) + ' for Phone1 code ' + rtrim(a.ADRSCODE) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.ADRSCODE = b.ADRSCODE 
    end 
   
  if update(PHONE2) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00102', 
             'PHONE2', 
             getdate(), 
             cast(a.PHONE2 as char(50)), 
             cast(b.PHONE2 as char(50)), 
             a.EMPLOYID, 
             'Phone2 changed for employee ' + rtrim(a.EMPLOYID) + ' for Phone2 code ' + rtrim(a.ADRSCODE) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.ADRSCODE = b.ADRSCODE 
    end 
   
  if update(PHONE3) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00102', 
             'PHONE3', 
             getdate(), 
             cast(a.PHONE3 as char(50)), 
             cast(b.PHONE3 as char(50)), 
             a.EMPLOYID, 
             'PHONE3 changed for employee ' + rtrim(a.EMPLOYID) + ' for PHONE3 code ' + rtrim(a.ADRSCODE) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.ADRSCODE = b.ADRSCODE 
    end 
   
  if update(FAX) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00102', 
             'FAX', 
             getdate(), 
             cast(a.FAX as char(50)), 
             cast(b.FAX as char(50)), 
             a.EMPLOYID, 
             'FAX changed for employee ' + rtrim(a.EMPLOYID) + ' for FAX code ' + rtrim(a.ADRSCODE) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.ADRSCODE = b.ADRSCODE 
    end 
   
  if update(Foreign_Address) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00102', 
             'Foreign_Address', 
             getdate(), 
             cast(a.Foreign_Address as char(50)), 
             cast(b.Foreign_Address as char(50)), 
             a.EMPLOYID, 
             'Foreign_Address changed for employee ' + rtrim(a.EMPLOYID) + ' for Foreign_Address code ' + rtrim(a.ADRSCODE) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.ADRSCODE = b.ADRSCODE 
    end 
   
  if update(Foreign_StateProvince) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00102', 
             'Foreign_StateProvince', 
             getdate(), 
             cast(a.Foreign_StateProvince as char(50)), 
             cast(b.Foreign_StateProvince as char(50)), 
             a.EMPLOYID, 
             'Foreign_StateProvince changed for employee ' + rtrim(a.EMPLOYID) + ' for Foreign_StateProvince code ' + rtrim(a.ADRSCODE) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.ADRSCODE = b.ADRSCODE 
    end 
   
  if update(Foreign_Postal_Code) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00102', 
             'Foreign_Postal_Code', 
             getdate(), 
             cast(a.Foreign_Postal_Code as char(50)), 
             cast(b.Foreign_Postal_Code as char(50)), 
             a.EMPLOYID, 
             'Foreign_Postal_Code changed for employee ' + rtrim(a.EMPLOYID) + ' for Foreign_Postal_Code code ' + rtrim(a.ADRSCODE) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.ADRSCODE = b.ADRSCODE 
    end 
   
  if update(CCode) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'UPR00102', 
             'CCode', 
             getdate(), 
             cast(a.CCode as char(50)), 
             cast(b.CCode as char(50)), 
             a.EMPLOYID, 
             'CCode changed for employee ' + rtrim(a.EMPLOYID) + ' for CCode code ' + rtrim(a.ADRSCODE) 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.ADRSCODE = b.ADRSCODE 
    end 

go 

go 

if exists (select 1 
           from   sysobjects 
           where  name = 'trackAddressCodeAdditions' 
                  and type = 'tr') 
  drop trigger trackAddressCodeAdditions 

go 

create trigger [trackAddressCodeAdditions] 
on UPR00102 
for insert 
as 
  insert trackPayrollChanges 
  select system_user, 
         'UPR00102', 
         'Inserted Record', 
         getdate(), 
         'Inserted Record', 
         'Inserted Record', 
         EMPLOYID, 
         'Address Code ' + rtrim(ADRSCODE) + ' was added for employee ' + rtrim(EMPLOYID) 
  from   inserted 

go 

/*DD00100*/ 
if exists (select 1 
           from   sysobjects 
           where  name = 'trackDDEmpMSTRAdditions1' 
                  and type = 'tr') 
  drop trigger [trackDDEmpMSTRAdditions1] 

go 

create trigger [trackDDEmpMSTRAdditions1] 
on DD00100 
for insert 
as 
  insert trackPayrollChanges 
  select system_user, 
         'DD00100', 
         'Inserted Record', 
         getdate(), 
         'Inserted Record', 
         'Inserted Record', 
         EMPLOYID, 
         'Record with DEX_ROW_ID ' + rtrim(cast(DEX_ROW_ID as char(6))) + ' was added for employee ' + rtrim(EMPLOYID) 
  from   inserted 

go 

if exists (select 1 
           from   sysobjects 
           where  name = 'trackDirectDepositMasterChanges' 
                  and type = 'tr') 
  drop trigger [trackDirectDepositMasterChanges] 

go 

create trigger [trackDirectDepositMasterChanges] 
on DD00100 
for update 
as 
  if update(INACTIVE) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'DD00100', 
             'INACTIVE', 
             getdate(), 
             cast(a.INACTIVE as char(50)), 
             cast(b.INACTIVE as char(50)), 
             a.EMPLOYID, 
             'Inactive was changed for Employee ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
   
  if update(DDREMAIN) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'DD00100', 
             'DDREMAIN', 
             getdate(), 
             cast(a.DDREMAIN as char(50)), 
             cast(b.DDREMAIN as char(50)), 
             a.EMPLOYID, 
             'Direct Deposit Remainder was changed for Employee ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 
   
  if update(INDEX1) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'DD00100', 
             'INDEX1', 
             getdate(), 
             cast(a.INDEX1 as char(50)), 
             cast(b.INDEX1 as char(50)), 
             a.EMPLOYID, 
             'Index was changed for Employee ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
    end 

go 

/*DD00200*/ 
if exists (select 1 
           from   sysobjects 
           where  name = 'trackDDEmpMSTRAdditions' 
                  and type = 'tr') 
  drop trigger [trackDDEmpMSTRAdditions] 

go 

create trigger [trackDDEmpMSTRAdditions] 
on DD00200 
for insert 
as 
  insert trackPayrollChanges 
  select system_user, 
         'DD00200', 
         'Inserted Record', 
         getdate(), 
         'Inserted Record', 
         'Inserted Record', 
         EMPLOYID, 
         'Record with DEX_ROW_ID ' + rtrim(cast(DEX_ROW_ID as char(6))) + ' was added for employee ' + rtrim(EMPLOYID) 
  from   inserted 

go 

if exists (select 1 
           from   sysobjects 
           where  name = 'trackDirectDepositEmployeeAccountChanges' 
                  and type = 'tr') 
  drop trigger [trackDirectDepositEmployeeAccountChanges] 

go 

create trigger [trackDirectDepositEmployeeAccountChanges] 
on DD00200 
for update 
as 
  if update(INACTIVE) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'DD00200', 
             'INACTIVE', 
             getdate(), 
             cast(a.INACTIVE as char(50)), 
             cast(b.INACTIVE as char(50)), 
             a.EMPLOYID, 
             'Inactive changed for Employee ID ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.INDEX1 = b.INDEX1 
    end 
   
  if update(DEDNMTHD) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'DD00200', 
             'DEDNMTHD', 
             getdate(), 
             cast(a.DEDNMTHD as char(50)), 
             cast(b.DEDNMTHD as char(50)), 
             a.EMPLOYID, 
             'Deduction Method changed for Employee ID ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.INDEX1 = b.INDEX1 
    end 
   
  if update(DEDUCTON) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'DD00200', 
             'DEDUCTON', 
             getdate(), 
             cast(a.DEDUCTON as char(50)), 
             cast(b.DEDUCTON as char(50)), 
             a.EMPLOYID, 
             'Deduction changed for Employee ID ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.INDEX1 = b.INDEX1 
    end 
   
  if update(DDPRE) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'DD00200', 
             'DDPRE', 
             getdate(), 
             cast(a.DDPRE as char(50)), 
             cast(b.DDPRE as char(50)), 
             a.EMPLOYID, 
             'Direct Deposit Prenote changed for Employee ID ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.INDEX1 = b.INDEX1 
    end 
     
  if update(DDPRECNT) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'DD00200', 
             'DDPRECNT', 
             getdate(), 
             cast(a.DDPRECNT as char(50)), 
             cast(b.DDPRECNT as char(50)), 
             a.EMPLOYID, 
             'Direct Deposit Prenote count changed for Employee ID ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.INDEX1 = b.INDEX1 
    end 
   
  if update(DDPCT) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'DD00200', 
             'DDPCT', 
             getdate(), 
             cast(a.DDPCT as char(50)), 
             cast(b.DDPCT as char(50)), 
             a.EMPLOYID, 
             'Direct Deposit Percent changed for Employee ID ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.INDEX1 = b.INDEX1 
    end 
     
  if update(DDAMTDLR) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'DD00200', 
             'DDAMTDLR', 
             getdate(), 
             cast(a.DDAMTDLR as char(50)), 
             cast(b.DDAMTDLR as char(50)), 
             a.EMPLOYID, 
             'Direct Deposit AmountDlr changed for Employee ID ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.INDEX1 = b.INDEX1 
    end 
   
  if update(DDACTNUM) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'DD00200', 
             'DDACTNUM', 
             getdate(), 
             cast(a.DDACTNUM as char(50)), 
             cast(b.DDACTNUM as char(50)), 
             a.EMPLOYID, 
             'Direct Deposit Account Number changed for Employee ID ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.INDEX1 = b.INDEX1 
    end 
   
  if update(DDTRANUM) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'DD00200', 
             'DDTRANUM', 
             getdate(), 
             cast(a.DDTRANUM as char(50)), 
             cast(b.DDTRANUM as char(50)), 
             a.EMPLOYID, 
             'Direct Deposit Transit Number changed for Employee ID ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.INDEX1 = b.INDEX1 
    end 
   
  if update(DDTRANS) 
    begin 
      insert trackPayrollChanges 
      select system_user, 
             'DD00200', 
             'DDTRANS', 
             getdate(), 
             cast(a.DDTRANS as char(50)), 
             cast(b.DDTRANS as char(50)), 
             a.EMPLOYID, 
             'Direct Deposit Transaction Code changed for Employee ID ' + a.EMPLOYID 
      from   deleted a 
             inner join inserted b 
               on a.EMPLOYID = b.EMPLOYID 
                  and a.INDEX1 = b.INDEX1 
    end 

go 